/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.piece.room;

import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.TemplateManager;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.StructurePieceTypes;
import xiroc.dungeoncrawl.dungeon.model.ModelSelector;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;

public class DungeonSpiderRoom
extends DungeonPiece {
    private BlockPos[] spawners;
    private BlockPos[] chests;

    public DungeonSpiderRoom(TemplateManager manager, CompoundNBT nbt) {
        super(StructurePieceTypes.SPIDER_ROOM, nbt);
        CompoundNBT pos;
        int i;
        ListNBT list;
        if (nbt.func_74764_b("spawners")) {
            list = nbt.func_150295_c("spawners", 10);
            this.spawners = new BlockPos[list.size()];
            for (i = 0; i < this.spawners.length; ++i) {
                pos = list.func_150305_b(i);
                this.spawners[i] = new BlockPos(pos.func_74762_e("x"), pos.func_74762_e("y"), pos.func_74762_e("z"));
            }
        }
        if (nbt.func_74764_b("chests")) {
            list = nbt.func_150295_c("chests", 10);
            this.chests = new BlockPos[list.size()];
            for (i = 0; i < this.chests.length; ++i) {
                pos = list.func_150305_b(i);
                this.chests[i] = new BlockPos(pos.func_74762_e("x"), pos.func_74762_e("y"), pos.func_74762_e("z"));
            }
        }
    }

    @Override
    public void customSetup(Random rand) {
        int floor = this.y + 1;
        int chests = 1 + rand.nextInt(2);
        int spawners = chests + rand.nextInt(2);
        this.chests = new BlockPos[chests];
        this.spawners = new BlockPos[spawners];
        int x = 0;
        int z = 0;
        for (int i = 0; i < spawners; ++i) {
            x = (x + 1 + rand.nextInt(3)) % 9;
            z = (z + 1 + rand.nextInt(3)) % 9;
            this.spawners[i] = new BlockPos(this.x + x, floor + rand.nextInt(2), this.z + z);
            if (i >= chests) continue;
            this.chests[i] = new BlockPos(this.spawners[i].func_177958_n(), this.spawners[i].func_177956_o() == floor ? floor + 1 : floor, this.spawners[i].func_177952_p());
        }
    }

    public boolean func_230383_a_(ISeedReader p_230383_1_, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random p_230383_4_, MutableBoundingBox p_230383_5_, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
        return true;
    }

    @Override
    public int getDungeonPieceType() {
        return 15;
    }

    @Override
    public void setupModel(DungeonBuilder builder, ModelSelector modelSelector, List<DungeonPiece> pieces, Random rand) {
    }

    @Override
    public void setupBoundingBox() {
        this.field_74887_e = new MutableBoundingBox(this.x, this.y, this.z, this.x + 8, this.y + 8, this.z + 8);
    }

    @Override
    public void func_143011_b(CompoundNBT tagCompound) {
        CompoundNBT compoundNBT;
        ListNBT list;
        super.func_143011_b(tagCompound);
        if (this.spawners != null) {
            list = new ListNBT();
            for (BlockPos pos : this.spawners) {
                compoundNBT = new CompoundNBT();
                compoundNBT.func_74768_a("x", pos.func_177958_n());
                compoundNBT.func_74768_a("y", pos.func_177956_o());
                compoundNBT.func_74768_a("z", pos.func_177952_p());
                list.add((Object)compoundNBT);
            }
            tagCompound.func_218657_a("spawners", (INBT)list);
        }
        if (this.chests != null) {
            list = new ListNBT();
            for (BlockPos pos : this.chests) {
                compoundNBT = new CompoundNBT();
                compoundNBT.func_74768_a("x", pos.func_177958_n());
                compoundNBT.func_74768_a("y", pos.func_177956_o());
                compoundNBT.func_74768_a("z", pos.func_177952_p());
                list.add((Object)compoundNBT);
            }
            tagCompound.func_218657_a("chests", (INBT)list);
        }
    }
}

