/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.treasure;

import java.util.Random;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.theme.Theme;

public class Loot {
    public static final ResourceLocation CHEST_STAGE_1 = DungeonCrawl.locate("chests/stage_1");
    public static final ResourceLocation CHEST_STAGE_2 = DungeonCrawl.locate("chests/stage_2");
    public static final ResourceLocation CHEST_STAGE_3 = DungeonCrawl.locate("chests/stage_3");
    public static final ResourceLocation CHEST_STAGE_4 = DungeonCrawl.locate("chests/stage_4");
    public static final ResourceLocation CHEST_STAGE_5 = DungeonCrawl.locate("chests/stage_5");
    public static final ResourceLocation FORGE = DungeonCrawl.locate("chests/forge");
    public static final ResourceLocation FOOD = DungeonCrawl.locate("chests/food");
    public static final ResourceLocation TREASURE_ROOM = DungeonCrawl.locate("chests/treasure_room");
    public static final ResourceLocation SUPPLY_CHEST = DungeonCrawl.locate("chests/supply_chest");
    public static final ResourceLocation LIBRARY = DungeonCrawl.locate("chests/library");
    public static final ResourceLocation SECRET_ROOM = DungeonCrawl.locate("chests/secret_room");
    public static final ResourceLocation DISPENSER_STAGE_1 = DungeonCrawl.locate("misc/dispenser_1");
    public static final ResourceLocation DISPENSER_STAGE_2 = DungeonCrawl.locate("misc/dispenser_2");
    public static final ResourceLocation DISPENSER_STAGE_3 = DungeonCrawl.locate("misc/dispenser_3");
    public static final ResourceLocation WITHER_SKELETON = DungeonCrawl.locate("monster_overrides/wither_skeleton");

    public static void setLoot(LockableLootTileEntity tile, ResourceLocation lootTable, Theme theme, Theme.SecondaryTheme secondaryTheme, Random rand) {
        tile.func_189404_a(lootTable, rand.nextLong());
        Loot.setLootInformation(tile.getTileData(), theme, secondaryTheme);
    }

    public static ResourceLocation getLootTable(int lootLevel, Random rand) {
        switch (lootLevel) {
            case 0: {
                return (double)rand.nextFloat() < 0.1 ? LootTables.field_186430_l : CHEST_STAGE_1;
            }
            case 1: {
                return (double)rand.nextFloat() < 0.1 ? LootTables.field_186422_d : CHEST_STAGE_2;
            }
            case 2: {
                return (double)rand.nextFloat() < 0.1 ? LootTables.field_186422_d : CHEST_STAGE_3;
            }
            case 3: {
                return (double)rand.nextFloat() < 0.1 ? LootTables.field_186427_i : CHEST_STAGE_4;
            }
            case 4: {
                return (double)rand.nextFloat() < 0.1 ? LootTables.field_186427_i : CHEST_STAGE_5;
            }
        }
        return CHEST_STAGE_5;
    }

    public static void setLootInformation(CompoundNBT nbt, Theme theme, Theme.SecondaryTheme secondaryTheme) {
        CompoundNBT data = new CompoundNBT();
        data.func_74778_a("theme", theme.getKey().toString());
        data.func_74778_a("secondaryTheme", secondaryTheme.getKey().toString());
        nbt.func_218657_a("dungeoncrawl", (INBT)data);
    }

    public static Tuple<Theme, Theme.SecondaryTheme> getLootInformation(CompoundNBT nbt) {
        CompoundNBT data = nbt.func_74775_l("dungeoncrawl");
        return new Tuple((Object)Theme.getTheme(new ResourceLocation(data.func_74779_i("theme"))), (Object)Theme.getSecondaryTheme(new ResourceLocation(data.func_74779_i("secondaryTheme"))));
    }
}

