/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.theme;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.registries.ForgeRegistries;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.block.DungeonBlocks;
import xiroc.dungeoncrawl.dungeon.block.pattern.CheckedPattern;
import xiroc.dungeoncrawl.dungeon.block.pattern.TerracottaPattern;
import xiroc.dungeoncrawl.dungeon.decoration.IDungeonDecoration;
import xiroc.dungeoncrawl.exception.DatapackLoadException;
import xiroc.dungeoncrawl.theme.Theme;
import xiroc.dungeoncrawl.util.IBlockStateProvider;
import xiroc.dungeoncrawl.util.JSONUtils;
import xiroc.dungeoncrawl.util.WeightedRandom;

public class JsonTheming {
    protected static Theme deserializeTheme(JsonObject object, ResourceLocation file) {
        JsonObject themeObject = object.get("theme").getAsJsonObject();
        IBlockStateProvider solid = JsonTheming.deserialize(themeObject, "solid", file);
        IBlockStateProvider generic = JsonTheming.deserialize(themeObject, "generic", file);
        IBlockStateProvider pillar = JsonTheming.deserialize(themeObject, "pillar", file);
        IBlockStateProvider fencing = JsonTheming.deserialize(themeObject, "fencing", file);
        IBlockStateProvider floor = JsonTheming.deserialize(themeObject, "floor", file);
        IBlockStateProvider fluid = JsonTheming.deserialize(themeObject, "fluid", file);
        IBlockStateProvider material = JsonTheming.deserialize(themeObject, "material", file);
        IBlockStateProvider stairs = JsonTheming.deserialize(themeObject, "stairs", file);
        IBlockStateProvider solidStairs = JsonTheming.deserialize(themeObject, "solid_stairs", file);
        IBlockStateProvider slab = JsonTheming.deserialize(themeObject, "slab", file);
        IBlockStateProvider solidSlab = JsonTheming.deserialize(themeObject, "solid_slab", file);
        IBlockStateProvider vanillaWall = JsonTheming.deserialize(themeObject, "wall", file);
        Theme theme = new Theme(pillar, solid, generic, floor, solidStairs, stairs, material, vanillaWall, slab, solidSlab, fencing, fluid);
        if (object.has("decorations")) {
            JsonArray array = object.getAsJsonArray("decorations");
            IDungeonDecoration[] decorations = new IDungeonDecoration[array.size()];
            for (int i = 0; i < decorations.length; ++i) {
                decorations[i] = IDungeonDecoration.fromJson(array.get(i).getAsJsonObject(), file);
            }
            theme.setDecorations(decorations);
        }
        if (object.has("secondary_theme")) {
            WeightedRandom.Builder builder = new WeightedRandom.Builder();
            object.getAsJsonArray("secondary_theme").forEach(element -> {
                JsonObject instance = element.getAsJsonObject();
                ResourceLocation key = new ResourceLocation(instance.get("key").getAsString());
                if (!Theme.KEY_TO_SECONDARY_THEME.containsKey(key)) {
                    throw new DatapackLoadException("Unknown secondary theme key " + key + " in " + file.toString());
                }
                builder.add(Theme.KEY_TO_SECONDARY_THEME.get(key), JSONUtils.getWeight(instance));
            });
            theme.subTheme = builder.build();
        }
        if (object.has("id")) {
            Theme.ID_TO_THEME.put(object.get("id").getAsInt(), theme);
        }
        return theme;
    }

    protected static Theme.SecondaryTheme deserializeSecondaryTheme(JsonObject object, ResourceLocation file) {
        JsonObject themeObject = object.get("theme").getAsJsonObject();
        IBlockStateProvider wallLog = JsonTheming.deserialize(themeObject, "pillar", file);
        IBlockStateProvider trapDoor = JsonTheming.deserialize(themeObject, "trapdoor", file);
        IBlockStateProvider door = JsonTheming.deserialize(themeObject, "door", file);
        IBlockStateProvider material = JsonTheming.deserialize(themeObject, "material", file);
        IBlockStateProvider stairs = JsonTheming.deserialize(themeObject, "stairs", file);
        IBlockStateProvider slab = JsonTheming.deserialize(themeObject, "slab", file);
        IBlockStateProvider fence = JsonTheming.deserialize(themeObject, "fence", file);
        IBlockStateProvider fenceGate = JsonTheming.deserialize(themeObject, "fence_gate", file);
        IBlockStateProvider button = JsonTheming.deserialize(themeObject, "button", file);
        IBlockStateProvider pressurePlate = JsonTheming.deserialize(themeObject, "pressure_plate", file);
        Theme.SecondaryTheme secondaryTheme = new Theme.SecondaryTheme(wallLog, trapDoor, door, material, stairs, slab, fence, fenceGate, button, pressurePlate);
        if (object.has("id")) {
            Theme.ID_TO_SECONDARY_THEME.put(object.get("id").getAsInt(), secondaryTheme);
        }
        return secondaryTheme;
    }

    protected static void deserializeThemeMapping(JsonObject object, Map<String, WeightedRandom.Builder<Theme>> themeMappingBuilders, WeightedRandom.Builder<Theme> defaultBuilder, ResourceLocation file) {
        if (JSONUtils.areRequirementsMet(object)) {
            object.getAsJsonObject("mapping").entrySet().forEach(entry -> {
                ArrayList<Tuple<ResourceLocation, Integer>> entries = JsonTheming.checkAndListThemes(entry);
                entries.forEach((Consumer<Tuple<ResourceLocation, Integer>>)((Consumer<Tuple>)tuple -> {
                    if (!Theme.KEY_TO_THEME.containsKey(tuple.func_76341_a())) {
                        throw new DatapackLoadException("Cannot resolve theme key " + tuple.func_76341_a() + " in " + file.toString());
                    }
                    themeMappingBuilders.computeIfAbsent((String)entry.getKey(), key -> new WeightedRandom.Builder()).add(Theme.KEY_TO_THEME.get(tuple.func_76341_a()), (Integer)tuple.func_76340_b());
                }));
            });
            if (object.has("default")) {
                object.getAsJsonArray("default").forEach(element -> {
                    JsonObject entry = element.getAsJsonObject();
                    ResourceLocation theme = new ResourceLocation(entry.get("key").getAsString());
                    if (!Theme.KEY_TO_THEME.containsKey(theme)) {
                        throw new DatapackLoadException("Cannot resolve theme key " + theme + " in the default case of " + file);
                    }
                    defaultBuilder.add(Theme.KEY_TO_THEME.get(theme), JSONUtils.getWeight(entry));
                });
            }
        }
    }

    protected static void deserializeSecondaryThemeMapping(JsonObject object, Map<String, WeightedRandom.Builder<Theme.SecondaryTheme>> secondaryThemeMappingBuilders, WeightedRandom.Builder<Theme.SecondaryTheme> defaultBuilder, ResourceLocation file) {
        if (JSONUtils.areRequirementsMet(object)) {
            object.getAsJsonObject("mapping").entrySet().forEach(entry -> {
                ArrayList<Tuple<ResourceLocation, Integer>> entries = JsonTheming.checkAndListThemes(entry);
                entries.forEach((Consumer<Tuple<ResourceLocation, Integer>>)((Consumer<Tuple>)tuple -> {
                    if (!Theme.KEY_TO_SECONDARY_THEME.containsKey(tuple.func_76341_a())) {
                        throw new DatapackLoadException("Cannot resolve secondary theme key " + tuple.func_76341_a() + " in " + file.toString());
                    }
                    secondaryThemeMappingBuilders.computeIfAbsent((String)entry.getKey(), key -> new WeightedRandom.Builder()).add(Theme.KEY_TO_SECONDARY_THEME.get(tuple.func_76341_a()), (Integer)tuple.func_76340_b());
                }));
            });
            if (object.has("default")) {
                object.getAsJsonArray("default").forEach(element -> {
                    JsonObject entry = element.getAsJsonObject();
                    ResourceLocation theme = new ResourceLocation(entry.get("key").getAsString());
                    if (!Theme.KEY_TO_SECONDARY_THEME.containsKey(theme)) {
                        throw new DatapackLoadException("Cannot resolve secondary theme key " + theme + " in the default case of " + file);
                    }
                    defaultBuilder.add(Theme.KEY_TO_SECONDARY_THEME.get(theme), JSONUtils.getWeight(entry));
                });
            }
        }
    }

    private static ArrayList<Tuple<ResourceLocation, Integer>> checkAndListThemes(Map.Entry<String, JsonElement> entry) {
        if (!ForgeRegistries.BIOMES.containsKey(new ResourceLocation(entry.getKey()))) {
            DungeonCrawl.LOGGER.warn("The biome {} does not exist.", (Object)entry.getKey());
        }
        ArrayList<Tuple<ResourceLocation, Integer>> entries = new ArrayList<Tuple<ResourceLocation, Integer>>();
        entry.getValue().getAsJsonArray().forEach(element -> {
            JsonObject jsonObject = element.getAsJsonObject();
            entries.add(new Tuple((Object)new ResourceLocation(jsonObject.get("key").getAsString()), (Object)JSONUtils.getWeight(jsonObject)));
        });
        return entries;
    }

    protected static void deserializeRandomThemeFile(JsonObject object, WeightedRandom.Builder<Theme> themes, WeightedRandom.Builder<Theme.SecondaryTheme> secondaryThemes, ResourceLocation file) {
        if (JSONUtils.areRequirementsMet(object)) {
            if (object.has("primary_themes")) {
                object.getAsJsonArray("primary_themes").forEach(element -> {
                    JsonObject entry = element.getAsJsonObject();
                    ResourceLocation key = new ResourceLocation(entry.get("key").getAsString());
                    if (!Theme.KEY_TO_THEME.containsKey(key)) {
                        throw new DatapackLoadException("Cannot resolve primary theme key " + key + " in " + file);
                    }
                    themes.add(Theme.KEY_TO_THEME.get(key), JSONUtils.getWeight(entry));
                });
            }
            if (object.has("secondary_themes")) {
                object.getAsJsonArray("secondary_themes").forEach(element -> {
                    JsonObject entry = element.getAsJsonObject();
                    ResourceLocation key = new ResourceLocation(entry.get("key").getAsString());
                    if (!Theme.KEY_TO_SECONDARY_THEME.containsKey(key)) {
                        throw new DatapackLoadException("Cannot resolve secondary theme key " + key + " in " + file);
                    }
                    secondaryThemes.add(Theme.KEY_TO_SECONDARY_THEME.get(key), JSONUtils.getWeight(entry));
                });
            }
        }
    }

    public static IBlockStateProvider deserialize(JsonObject base, String name, ResourceLocation file) {
        if (!base.has(name)) {
            DungeonCrawl.LOGGER.warn("Missing BlockState Provider \"{}\" in {}", (Object)name, (Object)file.toString());
            return null;
        }
        JsonObject object = (JsonObject)base.get(name);
        if (object.has("type")) {
            String type = object.get("type").getAsString();
            if (type.equalsIgnoreCase("random_block")) {
                JsonArray blockObjects = object.get("blocks").getAsJsonArray();
                WeightedRandom.Builder<BlockState> builder = new WeightedRandom.Builder<BlockState>();
                for (JsonElement blockElement : blockObjects) {
                    JsonObject blockObject = (JsonObject)blockElement;
                    Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockObject.get("block").getAsString()));
                    if (block != null) {
                        BlockState state = JSONUtils.getBlockState(block, blockObject);
                        builder.add(state, JSONUtils.getWeight(blockObject));
                        continue;
                    }
                    DungeonCrawl.LOGGER.error("Unknown block: {}", (Object)blockObject.get("block").getAsString());
                }
                return new WeightedRandomBlock(builder.build());
            }
            if (type.equalsIgnoreCase("block")) {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(object.get("block").getAsString()));
                if (block != null) {
                    BlockState state = JSONUtils.getBlockState(block, object);
                    return (world, pos, rotation) -> state;
                }
                DungeonCrawl.LOGGER.error("Unknown block: {}", (Object)object.get("block").getAsString());
                return (world, pos, rotation) -> Blocks.field_201941_jj.func_176223_P();
            }
            if (type.equalsIgnoreCase("pattern")) {
                switch (object.get("pattern_type").getAsString().toLowerCase(Locale.ROOT)) {
                    case "checked": {
                        return new CheckedPattern(JsonTheming.deserialize(object, "block_1", file), JsonTheming.deserialize(object, "block_2", file));
                    }
                    case "terracotta": {
                        return new TerracottaPattern(JsonTheming.deserialize(object, "block", file));
                    }
                }
                DungeonCrawl.LOGGER.error("Unknown block pattern type: " + object.get("pattern_type").getAsString());
                return null;
            }
            DungeonCrawl.LOGGER.error("Failed to load BlockState Provider {}: Unknown type {}.", (Object)object, (Object)type);
            return null;
        }
        DungeonCrawl.LOGGER.error("Invalid BlockState Provider \"{}\": Type not specified.", (Object)name);
        return null;
    }

    private static class WeightedRandomBlock
    implements IBlockStateProvider {
        private final WeightedRandom<BlockState> randomBlockState;

        WeightedRandomBlock(WeightedRandom<BlockState> randomBlockState) {
            this.randomBlockState = randomBlockState;
        }

        @Override
        public BlockState get(IWorld world, BlockPos pos, Rotation rotation) {
            return this.randomBlockState.roll(DungeonBlocks.RANDOM);
        }
    }
}

