/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.particle.util;

import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleBase;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleRotation;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public abstract class ParticleComponent {
    public void init(AdvancedParticleBase particle) {
    }

    public void preUpdate(AdvancedParticleBase particle) {
    }

    public void postUpdate(AdvancedParticleBase particle) {
    }

    public void preRender(AdvancedParticleBase particle, float partialTicks) {
    }

    public void postRender(AdvancedParticleBase particle, IVertexBuilder buffer, ActiveRenderInfo renderInfo, float partialTicks, int lightmap) {
    }

    public static Constant constant(float value) {
        return new Constant(value);
    }

    public static class FaceMotion
    extends ParticleComponent {
        @Override
        public void preRender(AdvancedParticleBase particle, float partialTicks) {
            super.preRender(particle, partialTicks);
            double dx = particle.getPosX() - particle.getPrevPosX();
            double dy = particle.getPosY() - particle.getPrevPosY();
            double dz = particle.getPosZ() - particle.getPrevPosZ();
            double d = Math.sqrt(dx * dx + dy * dy + dz * dz);
            if (d != 0.0) {
                if (particle.rotation instanceof ParticleRotation.EulerAngles) {
                    ParticleRotation.EulerAngles eulerRot = (ParticleRotation.EulerAngles)particle.rotation;
                    double a = dy / d;
                    a = Math.max(-1.0, Math.min(1.0, a));
                    float pitch = -((float)Math.asin(a));
                    float yaw = -((float)(Math.atan2(dz, dx) + Math.PI));
                    eulerRot.roll = pitch;
                    eulerRot.yaw = yaw;
                } else if (particle.rotation instanceof ParticleRotation.OrientVector) {
                    ParticleRotation.OrientVector orientRot = (ParticleRotation.OrientVector)particle.rotation;
                    orientRot.orientation = new Vector3d(dx, dy, dz).func_72432_b();
                }
            }
        }
    }

    public static class Orbit
    extends ParticleComponent {
        private final Vector3d[] location;
        private final AnimData phase;
        private final AnimData radius;
        private final AnimData axisX;
        private final AnimData axisY;
        private final AnimData axisZ;
        private final boolean faceCamera;

        public Orbit(Vector3d[] location, AnimData phase, AnimData radius, AnimData axisX, AnimData axisY, AnimData axisZ, boolean faceCamera) {
            this.location = location;
            this.phase = phase;
            this.radius = radius;
            this.axisX = axisX;
            this.axisY = axisY;
            this.axisZ = axisZ;
            this.faceCamera = faceCamera;
        }

        @Override
        public void init(AdvancedParticleBase particle) {
            this.apply(particle, 0.0f);
        }

        @Override
        public void preUpdate(AdvancedParticleBase particle) {
            float ageFrac = particle.getAge() / (float)particle.func_206254_h();
            this.apply(particle, ageFrac);
        }

        private void apply(AdvancedParticleBase particle, float t) {
            float p = this.phase.evaluate(t);
            float r = this.radius.evaluate(t);
            Vector3f axis = new Vector3f(this.axisX.evaluate(t), this.axisY.evaluate(t), this.axisZ.evaluate(t));
            axis.func_229194_d_();
            Quaternion quat = new Quaternion(axis, p * (float)Math.PI * 2.0f, false);
            Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f);
            Vector3f start = axis;
            start.func_195896_c(up);
            start.func_229194_d_();
            if (axis.equals((Object)up)) {
                start = new Vector3f(1.0f, 0.0f, 0.0f);
            }
            Vector3f newPos = start;
            newPos.func_214905_a(quat);
            newPos.func_195898_a(r);
            if (this.location.length > 0 && this.location[0] != null) {
                newPos.func_195904_b((float)this.location[0].field_72450_a, (float)this.location[0].field_72448_b, (float)this.location[0].field_72449_c);
            }
            particle.func_187109_b(newPos.func_195899_a(), newPos.func_195900_b(), newPos.func_195902_c());
        }
    }

    public static class Attractor
    extends ParticleComponent {
        private final Vector3d[] location;
        private final float strength;
        private final float killDist;
        private final EnumAttractorBehavior behavior;
        private Vector3d startLocation;

        public Attractor(Vector3d[] location, float strength, float killDist, EnumAttractorBehavior behavior) {
            this.location = location;
            this.strength = strength;
            this.killDist = killDist;
            this.behavior = behavior;
        }

        @Override
        public void init(AdvancedParticleBase particle) {
            this.startLocation = new Vector3d(particle.getPosX(), particle.getPosY(), particle.getPosZ());
        }

        @Override
        public void preUpdate(AdvancedParticleBase particle) {
            float ageFrac = particle.getAge() / (float)particle.func_206254_h();
            if (this.location.length > 0) {
                Vector3d destinationVec = this.location[0];
                Vector3d currPos = new Vector3d(particle.getPosX(), particle.getPosY(), particle.getPosZ());
                Vector3d diff = destinationVec.func_178788_d(currPos);
                if (diff.func_72433_c() < (double)this.killDist) {
                    particle.func_187112_i();
                }
                if (this.behavior == EnumAttractorBehavior.EXPONENTIAL) {
                    Vector3d path = destinationVec.func_178788_d(this.startLocation).func_186678_a(Math.pow(ageFrac, this.strength)).func_178787_e(this.startLocation).func_178788_d(currPos);
                    particle.func_187110_a(path.field_72450_a, path.field_72448_b, path.field_72449_c);
                } else if (this.behavior == EnumAttractorBehavior.LINEAR) {
                    Vector3d path = destinationVec.func_178788_d(this.startLocation).func_186678_a((double)ageFrac).func_178787_e(this.startLocation).func_178788_d(currPos);
                    particle.func_187110_a(path.field_72450_a, path.field_72448_b, path.field_72449_c);
                } else {
                    double dist = Math.max(diff.func_72433_c(), 0.001);
                    diff = diff.func_72432_b().func_186678_a((double)this.strength / (dist * dist));
                    particle.setMotionX(Math.min(particle.getMotionX() + diff.field_72450_a, 5.0));
                    particle.setMotionY(Math.min(particle.getMotionY() + diff.field_72448_b, 5.0));
                    particle.setMotionZ(Math.min(particle.getMotionZ() + diff.field_72449_c, 5.0));
                }
            }
        }

        public static enum EnumAttractorBehavior {
            LINEAR,
            EXPONENTIAL,
            SIMULATED;

        }
    }

    public static class PinLocation
    extends ParticleComponent {
        private final Vector3d[] location;

        public PinLocation(Vector3d[] location) {
            this.location = location;
        }

        @Override
        public void init(AdvancedParticleBase particle) {
            if (this.location != null && this.location.length > 0) {
                particle.func_187109_b(this.location[0].field_72450_a, this.location[0].field_72448_b, this.location[0].field_72449_c);
            }
        }

        @Override
        public void preUpdate(AdvancedParticleBase particle) {
            if (this.location != null && this.location.length > 0) {
                particle.func_187109_b(this.location[0].field_72450_a, this.location[0].field_72448_b, this.location[0].field_72449_c);
            }
        }
    }

    public static class PropertyControl
    extends ParticleComponent {
        private final AnimData animData;
        private final EnumParticleProperty property;
        private final boolean additive;

        public PropertyControl(EnumParticleProperty property, AnimData animData, boolean additive) {
            this.property = property;
            this.animData = animData;
            this.additive = additive;
        }

        @Override
        public void init(AdvancedParticleBase particle) {
            float value = this.animData.evaluate(0.0f);
            this.applyUpdate(particle, value);
            this.applyRender(particle, value);
        }

        @Override
        public void preRender(AdvancedParticleBase particle, float partialTicks) {
            float ageFrac = (particle.getAge() + partialTicks) / (float)particle.func_206254_h();
            float value = this.animData.evaluate(ageFrac);
            this.applyRender(particle, value);
        }

        @Override
        public void preUpdate(AdvancedParticleBase particle) {
            float ageFrac = particle.getAge() / (float)particle.func_206254_h();
            float value = this.animData.evaluate(ageFrac);
            this.applyUpdate(particle, value);
        }

        private void applyUpdate(AdvancedParticleBase particle, float value) {
            if (this.property == EnumParticleProperty.POS_X) {
                if (this.additive) {
                    particle.setPosX(particle.getPosX() + (double)value);
                } else {
                    particle.setPosX(value);
                }
            } else if (this.property == EnumParticleProperty.POS_Y) {
                if (this.additive) {
                    particle.setPosY(particle.getPosY() + (double)value);
                } else {
                    particle.setPosY(value);
                }
            } else if (this.property == EnumParticleProperty.POS_Z) {
                if (this.additive) {
                    particle.setPosZ(particle.getPosZ() + (double)value);
                } else {
                    particle.setPosZ(value);
                }
            } else if (this.property == EnumParticleProperty.MOTION_X) {
                if (this.additive) {
                    particle.setMotionX(particle.getMotionX() + (double)value);
                } else {
                    particle.setMotionX(value);
                }
            } else if (this.property == EnumParticleProperty.MOTION_Y) {
                if (this.additive) {
                    particle.setMotionY(particle.getMotionY() + (double)value);
                } else {
                    particle.setMotionY(value);
                }
            } else if (this.property == EnumParticleProperty.MOTION_Z) {
                if (this.additive) {
                    particle.setMotionZ(particle.getMotionZ() + (double)value);
                } else {
                    particle.setMotionZ(value);
                }
            } else if (this.property == EnumParticleProperty.AIR_DRAG) {
                particle.airDrag = this.additive ? (particle.airDrag += value) : value;
            }
        }

        private void applyRender(AdvancedParticleBase particle, float value) {
            if (this.property == EnumParticleProperty.RED) {
                particle.red = this.additive ? (particle.red += value) : value;
            } else if (this.property == EnumParticleProperty.GREEN) {
                particle.green = this.additive ? (particle.green += value) : value;
            } else if (this.property == EnumParticleProperty.BLUE) {
                particle.blue = this.additive ? (particle.blue += value) : value;
            } else if (this.property == EnumParticleProperty.ALPHA) {
                particle.alpha = this.additive ? (particle.alpha += value) : value;
            } else if (this.property == EnumParticleProperty.SCALE) {
                particle.scale = this.additive ? (particle.scale += value) : value;
            } else if (this.property == EnumParticleProperty.YAW) {
                if (particle.rotation instanceof ParticleRotation.EulerAngles) {
                    ParticleRotation.EulerAngles eulerRot = (ParticleRotation.EulerAngles)particle.rotation;
                    eulerRot.yaw = this.additive ? (eulerRot.yaw += value) : value;
                }
            } else if (this.property == EnumParticleProperty.PITCH) {
                if (particle.rotation instanceof ParticleRotation.EulerAngles) {
                    ParticleRotation.EulerAngles eulerRot = (ParticleRotation.EulerAngles)particle.rotation;
                    eulerRot.pitch = this.additive ? (eulerRot.pitch += value) : value;
                }
            } else if (this.property == EnumParticleProperty.ROLL) {
                if (particle.rotation instanceof ParticleRotation.EulerAngles) {
                    ParticleRotation.EulerAngles eulerRot = (ParticleRotation.EulerAngles)particle.rotation;
                    eulerRot.roll = this.additive ? (eulerRot.roll += value) : value;
                }
            } else if (this.property == EnumParticleProperty.PARTICLE_ANGLE && particle.rotation instanceof ParticleRotation.FaceCamera) {
                ParticleRotation.FaceCamera faceCameraRot = (ParticleRotation.FaceCamera)particle.rotation;
                faceCameraRot.faceCameraAngle = this.additive ? (faceCameraRot.faceCameraAngle += value) : value;
            }
        }

        public static enum EnumParticleProperty {
            POS_X,
            POS_Y,
            POS_Z,
            MOTION_X,
            MOTION_Y,
            MOTION_Z,
            RED,
            GREEN,
            BLUE,
            ALPHA,
            SCALE,
            YAW,
            PITCH,
            ROLL,
            PARTICLE_ANGLE,
            AIR_DRAG;

        }
    }

    public static class Constant
    extends AnimData {
        float value;

        public Constant(float value) {
            this.value = value;
        }

        @Override
        public float evaluate(float t) {
            return this.value;
        }
    }

    public static class Oscillator
    extends AnimData {
        float value1;
        float value2;
        float frequency;
        float phaseShift;

        public Oscillator(float value1, float value2, float frequency, float phaseShift) {
            this.value1 = value1;
            this.value2 = value2;
            this.frequency = frequency;
            this.phaseShift = phaseShift;
        }

        @Override
        public float evaluate(float t) {
            float a = (this.value2 - this.value1) / 2.0f;
            return (float)((double)(this.value1 + a) + (double)a * Math.cos(t * this.frequency + this.phaseShift));
        }
    }

    public static class KeyTrack
    extends AnimData {
        float[] values;
        float[] times;

        public KeyTrack(float[] values, float[] times) {
            this.values = values;
            this.times = times;
            if (values.length != times.length) {
                System.out.println("Malformed key track. Must have same number of keys and values or key track will evaluate to 0.");
            }
        }

        @Override
        public float evaluate(float t) {
            if (this.values.length != this.times.length) {
                return 0.0f;
            }
            for (int i = 0; i < this.times.length; ++i) {
                float time = this.times[i];
                if (t == time) {
                    return this.values[i];
                }
                if (t < time) {
                    if (i == 0) {
                        return this.values[0];
                    }
                    float a = (t - this.times[i - 1]) / (time - this.times[i - 1]);
                    return this.values[i - 1] * (1.0f - a) + this.values[i] * a;
                }
                if (i != this.values.length - 1) continue;
                return this.values[i];
            }
            return 0.0f;
        }

        public static KeyTrack startAndEnd(float startValue, float endValue) {
            return new KeyTrack(new float[]{startValue, endValue}, new float[]{0.0f, 1.0f});
        }

        public static KeyTrack oscillate(float value1, float value2, int frequency) {
            if (frequency <= 1) {
                new KeyTrack(new float[]{value1, value2}, new float[]{0.0f, 1.0f});
            }
            float step = 1.0f / (float)frequency;
            float[] times = new float[frequency + 1];
            float[] values = new float[frequency + 1];
            for (int i = 0; i < frequency + 1; ++i) {
                float value = i % 2 == 0 ? value1 : value2;
                times[i] = step * (float)i;
                values[i] = value;
            }
            return new KeyTrack(values, times);
        }
    }

    public static abstract class AnimData {
        public float evaluate(float t) {
            return 0.0f;
        }
    }
}

