/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.render.entity;

import com.bobmowzie.mowziesmobs.client.model.entity.ModelBarakoa;
import com.bobmowzie.mowziesmobs.client.render.RenderUtils;
import com.bobmowzie.mowziesmobs.client.render.entity.layer.ItemLayer;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoa;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.MaskType;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.EnumMap;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderBarakoa
extends MobRenderer<EntityBarakoa, ModelBarakoa<EntityBarakoa>> {
    private static final EnumMap<MaskType, ResourceLocation> TEXTURES = MaskType.newEnumMap(ResourceLocation.class, new ResourceLocation[0]);

    public RenderBarakoa(EntityRendererManager mgr) {
        super(mgr, new ModelBarakoa(), 0.6f);
        this.func_177094_a(new ItemLayer(this, ((ModelBarakoa)this.func_217764_d()).bone, Items.field_151103_aS.func_190903_i()));
        this.func_177094_a(new ItemLayer(this, ((ModelBarakoa)this.func_217764_d()).spear, ItemHandler.SPEAR.func_190903_i()));
        this.func_177094_a(new ItemLayer(this, ((ModelBarakoa)this.func_217764_d()).blowgun, ItemHandler.BLOWGUN.func_190903_i()));
        this.func_177094_a(new ItemLayer(this, ((ModelBarakoa)this.func_217764_d()).staff, ItemHandler.SUNBLOCK_STAFF.func_190903_i()));
    }

    public void render(EntityBarakoa entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        super.func_225623_a_((MobEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        boolean healingAnim = entityIn.getAnimation() == EntityBarakoa.HEAL_LOOP_ANIMATION || entityIn.getAnimation() == EntityBarakoa.HEAL_START_ANIMATION || entityIn.getAnimation() == EntityBarakoa.HEAL_STOP_ANIMATION;
        float f = MathHelper.func_219805_h((float)partialTicks, (float)entityIn.field_70760_ar, (float)entityIn.field_70761_aq);
        if (healingAnim && entityIn.staffPos != null && entityIn.staffPos.length > 0) {
            entityIn.staffPos[0] = RenderUtils.getWorldPosFromModel((Entity)entityIn, f, ((ModelBarakoa)this.func_217764_d()).staffEnd);
        }
    }

    protected float getDeathMaxRotation(EntityBarakoa entity) {
        return 0.0f;
    }

    public ResourceLocation getEntityTexture(EntityBarakoa entity) {
        return TEXTURES.get((Object)entity.getMask());
    }

    static {
        for (MaskType mask : MaskType.values()) {
            TEXTURES.put(mask, new ResourceLocation("mowziesmobs", "textures/entity/barakoa_" + mask.name + ((Boolean)ConfigHandler.CLIENT.oldBarakoaTextures.get() != false ? "_old" : "") + ".png"));
        }
    }
}

