/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity;

import com.bobmowzie.mowziesmobs.client.model.tools.IntermittentAnimation;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.IntermittentAnimatableEntity;
import com.bobmowzie.mowziesmobs.server.entity.MMBossInfoServer;
import com.bobmowzie.mowziesmobs.server.world.spawn.SpawnHandler;
import com.ilexiconn.llibrary.server.animation.Animation;
import com.ilexiconn.llibrary.server.animation.AnimationHandler;
import com.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.ArrayUtils;

public abstract class MowzieEntity
extends CreatureEntity
implements IEntityAdditionalSpawnData,
IAnimatedEntity,
IntermittentAnimatableEntity {
    private static final byte START_IA_HEALTH_UPDATE_ID = 4;
    public int frame;
    public float targetDistance = -1.0f;
    public float targetAngle = -1.0f;
    public boolean active;
    public LivingEntity blockingEntity = null;
    private int animationTick;
    private Animation animation = NO_ANIMATION;
    private final List<IntermittentAnimation<?>> intermittentAnimations = new ArrayList();
    public boolean playsHurtAnimation = true;
    protected boolean dropAfterDeathAnim = true;
    public boolean hurtInterruptsAnimation = false;
    @OnlyIn(value=Dist.CLIENT)
    public Vector3d[] socketPosArray;
    protected boolean prevOnGround;
    protected boolean prevPrevOnGround;
    protected boolean willLandSoon;
    private int killDataRecentlyHit;
    private DamageSource killDataCause;
    private PlayerEntity killDataAttackingPlayer;
    private final MMBossInfoServer bossInfo = new MMBossInfoServer(this);
    private LivingEntity healTarget;

    public MowzieEntity(EntityType<? extends MowzieEntity> type, World world) {
        super(type, world);
        if (world.field_72995_K) {
            this.socketPosArray = new Vector3d[0];
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233814_a_(Attributes.field_233823_f_);
    }

    protected ConfigHandler.SpawnConfig getSpawnConfig() {
        return null;
    }

    public static boolean spawnPredicate(EntityType type, IWorld world, SpawnReason reason, BlockPos spawnPos, Random rand) {
        ConfigHandler.SpawnConfig spawnConfig = SpawnHandler.spawnConfigs.get(type);
        if (spawnConfig != null) {
            ResourceLocation currDimensionName;
            if (rand.nextDouble() > (Double)spawnConfig.extraRarity.get()) {
                return false;
            }
            List dimensionNames = (List)spawnConfig.dimensions.get();
            if (!dimensionNames.contains((currDimensionName = ((ServerWorld)world).func_234923_W_().func_240901_a_()).toString())) {
                return false;
            }
            float heightMax = ((Integer)spawnConfig.heightMax.get()).intValue();
            float heightMin = ((Integer)spawnConfig.heightMin.get()).intValue();
            if ((float)spawnPos.func_177956_o() > heightMax && heightMax >= 0.0f) {
                return false;
            }
            if ((float)spawnPos.func_177956_o() < heightMin) {
                return false;
            }
            if (((Boolean)spawnConfig.needsDarkness.get()).booleanValue() && !MonsterEntity.func_223323_a((IServerWorld)((IServerWorld)world), (BlockPos)spawnPos, (Random)rand)) {
                return false;
            }
            Block block = world.func_180495_p(spawnPos.func_177977_b()).func_177230_c();
            ResourceLocation blockName = block.getRegistryName();
            List allowedBlocks = (List)spawnConfig.allowedBlocks.get();
            List allowedBlockTags = (List)spawnConfig.allowedBlockTags.get();
            if (blockName == null) {
                return false;
            }
            if (!(allowedBlocks.isEmpty() || allowedBlocks.contains(blockName.toString()) || allowedBlocks.contains(blockName.func_110623_a()))) {
                return false;
            }
            if (!allowedBlockTags.isEmpty() && !MowzieEntity.isBlockTagAllowed(allowedBlockTags, block)) {
                return false;
            }
            if (((Boolean)spawnConfig.needsSeeSky.get()).booleanValue() && !world.func_175710_j(spawnPos)) {
                return false;
            }
            if (((Boolean)spawnConfig.needsCantSeeSky.get()).booleanValue() && world.func_175710_j(spawnPos)) {
                return false;
            }
            List avoidStructures = (List)spawnConfig.avoidStructures.get();
            for (String structureName : avoidStructures) {
                double dist;
                BlockPos pos;
                Structure structure = (Structure)ForgeRegistries.STRUCTURE_FEATURES.getValue(new ResourceLocation(structureName));
                if (structure == null || (pos = ((ServerWorld)world).func_241117_a_(structure, spawnPos, 3, false)) == null || !((dist = spawnPos.func_177982_a(0, -spawnPos.func_177956_o(), 0).func_177951_i((Vector3i)pos)) < 900.0)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean structureNearby(Structure structure, ChunkGenerator chunkGenerator, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkY) {
        StructureSeparationSettings structureseparationsettings = chunkGenerator.func_235957_b_().func_236197_a_(structure);
        if (structureseparationsettings != null) {
            for (int i = chunkX - 10; i <= chunkX + 10; ++i) {
                for (int j = chunkY - 10; j <= chunkY + 10; ++j) {
                    ChunkPos chunkpos = structure.func_236392_a_(structureseparationsettings, seed, chunkRandom, i, j);
                    if (i != chunkpos.field_77276_a || j != chunkpos.field_77275_b) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isBlockTagAllowed(List<? extends String> allowedBlockTags, Block block) {
        for (String string : allowedBlockTags) {
            if (!BlockTags.func_199896_a().func_241834_b(new ResourceLocation(string)).func_230235_a_((Object)block)) continue;
            return true;
        }
        return false;
    }

    public void func_70071_h_() {
        this.prevPrevOnGround = this.prevOnGround;
        this.prevOnGround = this.field_70122_E;
        super.func_70071_h_();
        ++this.frame;
        if (this.getAnimation() != NO_ANIMATION) {
            ++this.animationTick;
            if (this.field_70170_p.field_72995_K && this.animationTick >= this.animation.getDuration()) {
                this.setAnimation(NO_ANIMATION);
            }
        }
        if (this.field_70173_aa % 4 == 0) {
            this.bossInfo.update();
        }
        if (this.func_70638_az() != null) {
            this.targetDistance = this.func_70032_d((Entity)this.func_70638_az()) - this.func_70638_az().func_213311_cf() / 2.0f;
            this.targetAngle = (float)this.getAngleBetweenEntities((Entity)this, (Entity)this.func_70638_az());
        }
        this.willLandSoon = !this.field_70122_E && this.field_70170_p.func_226664_a_(this.func_174813_aQ().func_191194_a(this.func_213322_ci()));
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
    }

    protected void onAnimationFinish(Animation animation) {
    }

    public void writeSpawnData(PacketBuffer buf) {
        buf.writeInt(ArrayUtils.indexOf((Object[])this.getAnimations(), (Object)this.getAnimation()));
        buf.writeInt(this.getAnimationTick());
    }

    public void readSpawnData(PacketBuffer buf) {
        this.field_70126_B = this.field_70177_z;
        this.field_70761_aq = this.field_70758_at = this.field_70759_as;
        this.field_70760_ar = this.field_70758_at;
        int animOrdinal = buf.readInt();
        int animTick = buf.readInt();
        this.setAnimation(animOrdinal == -1 ? IAnimatedEntity.NO_ANIMATION : this.getAnimations()[animOrdinal]);
        this.setAnimationTick(animTick);
    }

    public boolean func_70652_k(Entity entityIn) {
        return this.attackEntityAsMob(entityIn, 1.0f, 1.0f);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean attackEntityAsMob(Entity entityIn, float damageMultiplier, float applyKnockbackMultiplier) {
        return this.attackEntityAsMob(entityIn, damageMultiplier, applyKnockbackMultiplier, false);
    }

    public boolean attackEntityAsMob(Entity entityIn, float damageMultiplier, float applyKnockbackMultiplier, boolean canDisableShield) {
        boolean flag;
        int i;
        float f = (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e() * damageMultiplier;
        float f1 = (float)this.func_110148_a(Attributes.field_233824_g_).func_111126_e() * applyKnockbackMultiplier;
        if (entityIn instanceof LivingEntity) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (CreatureAttribute)((LivingEntity)entityIn).func_70668_bt());
            f1 += (float)EnchantmentHelper.func_77501_a((LivingEntity)this);
        }
        if ((i = EnchantmentHelper.func_90036_a((LivingEntity)this)) > 0) {
            entityIn.func_70015_d(i * 4);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), f)) {
            if (f1 > 0.0f && entityIn instanceof LivingEntity) {
                ((LivingEntity)entityIn).func_233627_a_(f1 * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
            }
            if (entityIn instanceof PlayerEntity) {
                ItemStack itemstack1;
                PlayerEntity playerentity = (PlayerEntity)entityIn;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = playerentity.func_184587_cr() ? playerentity.func_184607_cu() : ItemStack.field_190927_a;
                if ((!itemstack.func_190926_b() && itemstack.canDisableShield(itemstack1, (LivingEntity)playerentity, (LivingEntity)this) || canDisableShield) && !itemstack1.func_190926_b() && itemstack1.isShield((LivingEntity)playerentity)) {
                    float f2 = 0.25f + (float)EnchantmentHelper.func_185293_e((LivingEntity)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f2) {
                        playerentity.func_184811_cZ().func_185145_a(itemstack.func_77973_b(), 100);
                        this.field_70170_p.func_72960_a((Entity)playerentity, (byte)30);
                    }
                }
            }
            this.func_174815_a((LivingEntity)this, entityIn);
            this.func_130011_c(entityIn);
        }
        return flag;
    }

    public float getHealthRatio() {
        return this.func_110143_aJ() / this.func_110138_aP();
    }

    public double getAngleBetweenEntities(Entity first, Entity second) {
        return Math.atan2(second.func_226281_cx_() - first.func_226281_cx_(), second.func_226277_ct_() - first.func_226277_ct_()) * 57.29577951308232 + 90.0;
    }

    public List<PlayerEntity> getPlayersNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        List nearbyEntities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(distanceX, distanceY, distanceZ));
        List<PlayerEntity> listEntityPlayers = nearbyEntities.stream().filter(entityNeighbor -> entityNeighbor instanceof PlayerEntity && (double)this.func_70032_d((Entity)entityNeighbor) <= radius + (double)(entityNeighbor.func_213311_cf() / 2.0f)).map(entityNeighbor -> (PlayerEntity)entityNeighbor).collect(Collectors.toList());
        return listEntityPlayers;
    }

    public List<LivingEntity> getAttackableEntityLivingBaseNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        List nearbyEntities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(distanceX, distanceY, distanceZ));
        List<LivingEntity> listEntityLivingBase = nearbyEntities.stream().filter(entityNeighbor -> entityNeighbor instanceof LivingEntity && ((LivingEntity)entityNeighbor).func_190631_cK() && (!(entityNeighbor instanceof PlayerEntity) || !((PlayerEntity)entityNeighbor).func_184812_l_()) && (double)this.func_70032_d((Entity)entityNeighbor) <= radius + (double)(entityNeighbor.func_213311_cf() / 2.0f)).map(entityNeighbor -> (LivingEntity)entityNeighbor).collect(Collectors.toList());
        return listEntityLivingBase;
    }

    public List<LivingEntity> getEntityLivingBaseNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        return this.getEntitiesNearby(LivingEntity.class, distanceX, distanceY, distanceZ, radius);
    }

    public <T extends Entity> List<T> getEntitiesNearby(Class<T> entityClass, double r) {
        return this.field_70170_p.func_175647_a(entityClass, this.func_174813_aQ().func_72314_b(r, r, r), e -> e != this && (double)this.func_70032_d((Entity)e) <= r + (double)(e.func_213311_cf() / 2.0f));
    }

    public <T extends Entity> List<T> getEntitiesNearby(Class<T> entityClass, double dX, double dY, double dZ, double r) {
        return this.field_70170_p.func_175647_a(entityClass, this.func_174813_aQ().func_72314_b(dX, dY, dZ), e -> e != this && (double)this.func_70032_d((Entity)e) <= r + (double)(e.func_213311_cf() / 2.0f) && e.func_226278_cu_() <= this.func_226278_cu_() + dY);
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.func_110143_aJ() <= 0.0f) {
            Animation death = this.getDeathAnimation();
            if (death != null) {
                this.onDeathUpdate(death.getDuration() - 20);
            } else {
                this.onDeathUpdate(20);
            }
        }
    }

    private void onDeathUpdate(int deathDuration) {
        this.onDeathAIUpdate();
        ++this.field_70725_aQ;
        if (this.field_70725_aQ == deathDuration) {
            this.field_70717_bb = this.killDataAttackingPlayer;
            this.field_70718_bc = this.killDataRecentlyHit;
            if (!this.field_70170_p.func_201670_d() && this.dropAfterDeathAnim && this.killDataCause != null) {
                this.func_213345_d(this.killDataCause);
            }
            this.remove(false);
            for (int i = 0; i < 20; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197598_I, this.func_226282_d_(1.0), this.func_226279_cv_(), this.func_226287_g_(1.0), d0, d1, d2);
            }
        }
    }

    protected void onDeathAIUpdate() {
    }

    protected final void func_70609_aI() {
    }

    public void func_70645_a(DamageSource cause) {
        if (ForgeHooks.onLivingDeath((LivingEntity)this, (DamageSource)cause)) {
            return;
        }
        if (!this.field_70729_aU) {
            Entity entity = cause.func_76346_g();
            LivingEntity livingentity = this.func_94060_bK();
            if (this.field_70744_aE >= 0 && livingentity != null) {
                livingentity.func_191956_a((Entity)this, this.field_70744_aE, cause);
            }
            if (this.func_70608_bn()) {
                this.func_213366_dy();
            }
            this.field_70729_aU = true;
            this.func_110142_aN().func_94549_h();
            if (this.field_70170_p instanceof ServerWorld) {
                if (entity != null) {
                    entity.func_241847_a((ServerWorld)this.field_70170_p, (LivingEntity)this);
                }
                if (!this.dropAfterDeathAnim) {
                    this.func_213345_d(cause);
                }
                this.func_226298_f_(livingentity);
            }
            this.killDataCause = cause;
            this.killDataRecentlyHit = this.field_70718_bc;
            this.killDataAttackingPlayer = this.field_70717_bb;
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_213301_b(Pose.DYING);
            this.bossInfo.update();
        }
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        boolean attack = super.func_70097_a(source, damage);
        if (attack) {
            if (this.func_110143_aJ() > 0.0f && (this.getAnimation() == NO_ANIMATION || this.hurtInterruptsAnimation) && this.playsHurtAnimation) {
                AnimationHandler.INSTANCE.sendAnimationMessage(this, this.getHurtAnimation());
            } else if (this.func_110143_aJ() <= 0.0f) {
                AnimationHandler.INSTANCE.sendAnimationMessage(this, this.getDeathAnimation());
            }
        }
        return attack;
    }

    protected void addIntermittentAnimation(IntermittentAnimation animation) {
        animation.setID((byte)this.intermittentAnimations.size());
        this.intermittentAnimations.add(animation);
    }

    public void func_70103_a(byte id) {
        if (id >= 4 && id - 4 < this.intermittentAnimations.size()) {
            this.intermittentAnimations.get(id - 4).start();
            return;
        }
        super.func_70103_a(id);
    }

    @Override
    public byte getOffsetEntityState() {
        return 4;
    }

    public void circleEntity(Entity target, float radius, float speed, boolean direction, int circleFrame, float offset, float moveSpeedMultiplier) {
        int directionInt = direction ? 1 : -1;
        double t = (double)(directionInt * circleFrame) * 0.5 * (double)speed / (double)radius + (double)offset;
        Vector3d movePos = target.func_213303_ch().func_72441_c((double)radius * Math.cos(t), 0.0, (double)radius * Math.sin(t));
        this.func_70661_as().func_75492_a(movePos.func_82615_a(), movePos.func_82617_b(), movePos.func_82616_c(), (double)(speed * moveSpeedMultiplier));
    }

    protected void repelEntities(float x, float y, float z, float radius) {
        List<LivingEntity> nearbyEntities = this.getEntityLivingBaseNearby(x, y, z, radius);
        for (Entity entity : nearbyEntities) {
            if (!entity.func_70067_L() || entity.field_70145_X) continue;
            double angle = (this.getAngleBetweenEntities((Entity)this, entity) + 90.0) * Math.PI / 180.0;
            entity.func_213293_j(-0.1 * Math.cos(angle), entity.func_213322_ci().field_72448_b, -0.1 * Math.sin(angle));
        }
    }

    @Override
    public int getAnimationTick() {
        return this.animationTick;
    }

    @Override
    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    @Override
    public Animation getAnimation() {
        return this.animation;
    }

    @Override
    public void setAnimation(Animation animation) {
        if (animation == NO_ANIMATION) {
            this.onAnimationFinish(this.animation);
        }
        this.animation = animation;
        this.setAnimationTick(0);
    }

    public abstract Animation getDeathAnimation();

    public abstract Animation getHurtAnimation();

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public void func_200203_b(ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    protected boolean hasBossBar() {
        return false;
    }

    protected BossInfo.Color bossBarColor() {
        return BossInfo.Color.PURPLE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setSocketPosArray(int index, Vector3d pos) {
        if (this.socketPosArray != null && this.socketPosArray.length > index) {
            this.socketPosArray[index] = pos;
        }
    }

    public boolean canBePushedByEntity(Entity entity) {
        return true;
    }

    public void func_70108_f(Entity entityIn) {
        double d1;
        double d0;
        double d2;
        if (!(this.func_70608_bn() || this.func_184223_x(entityIn) || entityIn.field_70145_X || this.field_70145_X || !((d2 = MathHelper.func_76132_a((double)(d0 = entityIn.func_226277_ct_() - this.func_226277_ct_()), (double)(d1 = entityIn.func_226281_cx_() - this.func_226281_cx_()))) >= (double)0.01f))) {
            d2 = MathHelper.func_76133_a((double)d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            d0 *= (double)(1.0f - this.field_70144_Y);
            d1 *= (double)(1.0f - this.field_70144_Y);
            if (!this.func_184207_aI() && this.canBePushedByEntity(entityIn)) {
                this.func_70024_g(-d0, 0.0, -d1);
            }
            if (!entityIn.func_184207_aI()) {
                entityIn.func_70024_g(d0, 0.0, d1);
            }
        }
    }

    @Nullable
    public LivingEntity getHealTarget() {
        return this.healTarget;
    }

    public void setHealTarget(@Nullable LivingEntity entitylivingbaseIn) {
        this.healTarget = entitylivingbaseIn;
    }
}

