/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.barakoa;

import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoa;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public abstract class EntityBarakoan<L extends LivingEntity>
extends EntityBarakoa {
    protected static final Optional<UUID> ABSENT_LEADER = Optional.empty();
    private static final DataParameter<Optional<UUID>> LEADER = EntityDataManager.func_187226_a(EntityBarakoan.class, (IDataSerializer)DataSerializers.field_187203_m);
    private final Class<L> leaderClass;
    public int index;
    protected L leader;
    public boolean shouldSetDead;

    public EntityBarakoan(EntityType<? extends EntityBarakoan> type, World world, Class<L> leaderClass) {
        this(type, world, leaderClass, null);
    }

    public EntityBarakoan(EntityType<? extends EntityBarakoan> type, World world, Class<L> leaderClass, L leader) {
        super((EntityType<? extends EntityBarakoa>)type, world);
        this.leaderClass = leaderClass;
        if (leader != null) {
            this.setLeaderUUID(leader.func_110124_au());
        }
        this.shouldSetDead = false;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(LEADER, ABSENT_LEADER);
    }

    public Optional<UUID> getLeaderUUID() {
        return (Optional)this.func_184212_Q().func_187225_a(LEADER);
    }

    public void setLeaderUUID(UUID uuid) {
        this.setLeaderUUID(Optional.of(uuid));
    }

    public void setLeaderUUID(Optional<UUID> uuid) {
        this.func_184212_Q().func_187227_b(LEADER, uuid);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)ItemHandler.BARAKOA_SPAWN_EGG);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.leader == null && this.getLeaderUUID().isPresent()) {
            this.leader = this.getLeader();
            if (this.leader != null) {
                this.addAsPackMember();
            }
        }
        if (this.shouldSetDead) {
            this.func_70106_y();
        }
    }

    @Override
    protected void updateCircling() {
        LivingEntity target = this.func_70638_az();
        if (this.leader != null && target != null) {
            if (!this.attacking && this.targetDistance < 5.0f) {
                this.circleEntity((Entity)target, 7.0f, 0.3f, true, this.getTribeCircleTick(), (float)((double)(this.index + 1) * (Math.PI * 2) / (double)(this.getPackSize() + 1)), 1.75f);
            } else {
                this.circleEntity((Entity)target, 7.0f, 0.3f, true, this.getTribeCircleTick(), (float)((double)(this.index + 1) * (Math.PI * 2) / (double)(this.getPackSize() + 1)), 1.0f);
            }
        } else {
            super.updateCircling();
        }
    }

    @Override
    public void func_70645_a(DamageSource source) {
        super.func_70645_a(source);
        if (this.leader != null) {
            this.removeAsPackMember();
        }
    }

    public void setShouldSetDead() {
        this.shouldSetDead = true;
    }

    public void func_70106_y() {
        if (this.leader != null) {
            this.removeAsPackMember();
        }
        super.func_70106_y();
    }

    public L getLeader() {
        Optional<UUID> uuid = this.getLeaderUUID();
        if (uuid.isPresent()) {
            List potentialLeaders = this.field_70170_p.func_217357_a(this.leaderClass, this.func_174813_aQ().func_72314_b(32.0, 32.0, 32.0));
            for (LivingEntity entity : potentialLeaders) {
                if (!uuid.get().equals(entity.func_110124_au())) continue;
                return (L)entity;
            }
        }
        return null;
    }

    public boolean func_213392_I() {
        return this.leader != null;
    }

    protected abstract int getTribeCircleTick();

    protected abstract int getPackSize();

    protected abstract void addAsPackMember();

    protected abstract void removeAsPackMember();

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        Optional<UUID> leader = this.getLeaderUUID();
        if (leader.isPresent()) {
            compound.func_74778_a("leaderUUID", leader.get().toString());
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        String uuid = compound.func_74779_i("leaderUUID");
        if (uuid.isEmpty()) {
            this.setLeaderUUID(ABSENT_LEADER);
        } else {
            this.setLeaderUUID(UUID.fromString(uuid));
        }
    }
}

