/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.barakoa.trade;

import com.bobmowzie.mowziesmobs.server.entity.barakoa.trade.Trade;
import com.google.common.collect.ImmutableSet;
import java.util.Random;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;

public final class TradeStore {
    public static final TradeStore EMPTY = new TradeStore((ImmutableSet<Trade>)ImmutableSet.of(), 0);
    private final ImmutableSet<Trade> trades;
    private final int totalWeight;

    private TradeStore(ImmutableSet<Trade> trades, int totalWeight) {
        this.trades = trades;
        this.totalWeight = totalWeight;
    }

    public boolean hasStock() {
        return this.trades.size() > 0;
    }

    public Trade get(Random rng) {
        if (this.totalWeight <= 0) {
            return null;
        }
        int w = rng.nextInt(this.totalWeight);
        for (Trade t : this.trades) {
            if ((w -= t.getWeight()) >= 0) continue;
            return t;
        }
        return null;
    }

    public CompoundNBT serialize() {
        CompoundNBT compound = new CompoundNBT();
        ListNBT tradesList = new ListNBT();
        for (Trade trade : this.trades) {
            tradesList.add((Object)trade.serialize());
        }
        compound.func_218657_a("trades", (INBT)tradesList);
        return compound;
    }

    public static TradeStore deserialize(CompoundNBT compound) {
        ListNBT tradesList = compound.func_150295_c("trades", 10);
        int totalWeight = 0;
        ImmutableSet.Builder trades = new ImmutableSet.Builder();
        for (int i = 0; i < tradesList.size(); ++i) {
            Trade trade = Trade.deserialize(tradesList.func_150305_b(i));
            if (trade == null) continue;
            trades.add((Object)trade);
            totalWeight += trade.getWeight();
        }
        return new TradeStore((ImmutableSet<Trade>)trades.build(), totalWeight);
    }

    public static final class Builder {
        private final ImmutableSet.Builder<Trade> trades = new ImmutableSet.Builder();
        private int totalWeight;

        public Builder addTrade(Item input, int inputCount, Item output, int outputCount, int weight) {
            return this.addTrade(input, inputCount, null, output, outputCount, null, weight);
        }

        public Builder addTrade(Item input, int inputCount, CompoundNBT inputMeta, Item output, int outputCount, CompoundNBT outputMeta, int weight) {
            return this.addTrade(new ItemStack((IItemProvider)input, inputCount, inputMeta), new ItemStack((IItemProvider)output, outputCount, outputMeta), weight);
        }

        public Builder addTrade(ItemStack input, ItemStack output, int weight) {
            this.trades.add((Object)new Trade(input, output, weight));
            this.totalWeight += weight;
            return this;
        }

        public TradeStore build() {
            return new TradeStore(this.trades.build(), this.totalWeight);
        }
    }
}

