/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.effects;

import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityBlockSwapper
extends Entity {
    private static final DataParameter<Optional<BlockState>> ORIG_BLOCK_STATE = EntityDataManager.func_187226_a(EntityBlockSwapper.class, (IDataSerializer)DataSerializers.field_187197_g);
    private static final DataParameter<Integer> RESTORE_TIME = EntityDataManager.func_187226_a(EntityBlockSwapper.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<BlockPos> POS = EntityDataManager.func_187226_a(EntityBlockSwapper.class, (IDataSerializer)DataSerializers.field_187200_j);
    private int duration;
    private final boolean breakParticlesEnd;
    private BlockPos pos;

    public EntityBlockSwapper(EntityType<? extends EntityBlockSwapper> type, World world) {
        super(type, world);
        this.breakParticlesEnd = false;
    }

    public EntityBlockSwapper(EntityType<? extends EntityBlockSwapper> type, World world, BlockPos pos, BlockState newBlock, int duration, boolean breakParticlesStart, boolean breakParticlesEnd) {
        super(type, world);
        List swappers;
        this.setStorePos(pos);
        this.setRestoreTime(duration);
        this.breakParticlesEnd = breakParticlesEnd;
        this.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        if (!world.field_72995_K) {
            this.setOrigBlock(world.func_180495_p(pos));
            if (breakParticlesStart) {
                world.func_175655_b(pos, false);
            }
            world.func_175656_a(pos, newBlock);
        }
        if (!(swappers = world.func_217357_a(EntityBlockSwapper.class, this.func_174813_aQ())).isEmpty()) {
            EntityBlockSwapper swapper = (EntityBlockSwapper)((Object)swappers.get(0));
            this.setOrigBlock(swapper.getOrigBlock());
            swapper.func_70106_y();
        }
    }

    public static void swapBlock(World world, BlockPos pos, BlockState newBlock, int duration, boolean breakParticlesStart, boolean breakParticlesEnd) {
        if (!world.field_72995_K) {
            EntityBlockSwapper swapper = new EntityBlockSwapper(EntityHandler.BLOCK_SWAPPER, world, pos, newBlock, duration, breakParticlesStart, breakParticlesEnd);
            world.func_217376_c((Entity)swapper);
        }
    }

    public boolean func_145770_h(double p_145770_1_, double p_145770_3_, double p_145770_5_) {
        return false;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(ORIG_BLOCK_STATE, Optional.of(Blocks.field_150346_d.func_176223_P()));
        this.func_184212_Q().func_187214_a(RESTORE_TIME, (Object)20);
        this.func_184212_Q().func_187214_a(POS, (Object)new BlockPos(0, 0, 0));
    }

    public int getRestoreTime() {
        return (Integer)this.field_70180_af.func_187225_a(RESTORE_TIME);
    }

    public void setRestoreTime(int restoreTime) {
        this.field_70180_af.func_187227_b(RESTORE_TIME, (Object)restoreTime);
        this.duration = restoreTime;
    }

    public BlockPos getStorePos() {
        return (BlockPos)this.field_70180_af.func_187225_a(POS);
    }

    public void setStorePos(BlockPos bpos) {
        this.field_70180_af.func_187227_b(POS, (Object)bpos);
        this.pos = bpos;
    }

    @Nullable
    public BlockState getOrigBlock() {
        Optional opState = (Optional)this.func_184212_Q().func_187225_a(ORIG_BLOCK_STATE);
        return opState.orElse(null);
    }

    public void setOrigBlock(BlockState block) {
        this.func_184212_Q().func_187227_b(ORIG_BLOCK_STATE, Optional.of(block));
    }

    public void restoreBlock() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.breakParticlesEnd) {
                this.field_70170_p.func_175655_b(this.pos, false);
            }
            this.field_70170_p.func_175656_a(this.pos, this.getOrigBlock());
            this.func_70106_y();
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa > this.duration && this.field_70170_p.func_217357_a(PlayerEntity.class, this.func_174813_aQ()).isEmpty()) {
            this.restoreBlock();
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        Optional blockOption = (Optional)this.func_184212_Q().func_187225_a(ORIG_BLOCK_STATE);
        blockOption.ifPresent(blockState -> compound.func_218657_a("block", (INBT)NBTUtil.func_190009_a((BlockState)blockState)));
        compound.func_74768_a("restoreTime", this.getRestoreTime());
        compound.func_74768_a("storePosX", this.getStorePos().func_177958_n());
        compound.func_74768_a("storePosY", this.getStorePos().func_177956_o());
        compound.func_74768_a("storePosZ", this.getStorePos().func_177952_p());
    }

    public void func_70037_a(CompoundNBT compound) {
        INBT blockNBT = compound.func_74781_a("block");
        if (blockNBT != null) {
            BlockState blockState = NBTUtil.func_190008_d((CompoundNBT)((CompoundNBT)blockNBT));
            this.setOrigBlock(blockState);
        }
        this.setRestoreTime(compound.func_74762_e("restoreTime"));
        this.setStorePos(new BlockPos(compound.func_74762_e("storePosX"), compound.func_74762_e("storePosY"), compound.func_74762_e("storePosZ")));
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

