/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.message;

import com.bobmowzie.mowziesmobs.server.capability.CapabilityHandler;
import com.bobmowzie.mowziesmobs.server.capability.FrozenCapability;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageAddFreezeProgress {
    private int entityID;
    private float amount;

    public MessageAddFreezeProgress() {
    }

    public MessageAddFreezeProgress(LivingEntity entity, float amount) {
        this.entityID = entity.func_145782_y();
        this.amount = amount;
    }

    public static void serialize(MessageAddFreezeProgress message, PacketBuffer buf) {
        buf.func_150787_b(message.entityID);
        buf.writeFloat(message.amount);
    }

    public static MessageAddFreezeProgress deserialize(PacketBuffer buf) {
        MessageAddFreezeProgress message = new MessageAddFreezeProgress();
        message.entityID = buf.func_150792_a();
        message.amount = buf.readFloat();
        return message;
    }

    public static class Handler
    implements BiConsumer<MessageAddFreezeProgress, Supplier<NetworkEvent.Context>> {
        @Override
        public void accept(MessageAddFreezeProgress message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                LivingEntity living;
                FrozenCapability.IFrozenCapability frozenCapability;
                Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityID);
                if (entity instanceof LivingEntity && (frozenCapability = CapabilityHandler.getCapability((Entity)(living = (LivingEntity)entity), FrozenCapability.FrozenProvider.FROZEN_CAPABILITY)) != null) {
                    frozenCapability.setFreezeProgress(frozenCapability.getFreezeProgress() + message.amount);
                    frozenCapability.setFreezeDecayDelay(FrozenCapability.MAX_FREEZE_DECAY_DELAY);
                }
            });
            context.setPacketHandled(true);
        }
    }
}

