/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.world.feature.structure;

import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class MowzieStructure
extends Structure<NoFeatureConfig> {
    public MowzieStructure(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public abstract ConfigHandler.GenerationConfig getGenerationConfig();

    public boolean checkHeightLimitAgainstSurface() {
        return true;
    }

    public boolean avoidStructures() {
        return false;
    }

    public boolean avoidWater() {
        return true;
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    protected boolean func_230363_a_(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig featureConfig) {
        int landHeight;
        BlockPos centerOfChunk = new BlockPos((chunkX << 4) + 7, 0, (chunkZ << 4) + 7);
        if (this.checkHeightLimitAgainstSurface()) {
            landHeight = chunkGenerator.func_222532_b(centerOfChunk.func_177958_n(), centerOfChunk.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
            double minHeight = (Double)this.getGenerationConfig().heightMin.get();
            double maxHeight = (Double)this.getGenerationConfig().heightMax.get();
            if (minHeight != -1.0 && (double)landHeight < minHeight) {
                return false;
            }
            if (maxHeight != -1.0 && (double)landHeight > maxHeight) {
                return false;
            }
        }
        if (this.avoidWater()) {
            landHeight = chunkGenerator.func_222529_a(centerOfChunk.func_177958_n(), centerOfChunk.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
            IBlockReader columnOfBlocks = chunkGenerator.func_230348_a_(centerOfChunk.func_177958_n(), centerOfChunk.func_177952_p());
            BlockState topBlock = columnOfBlocks.func_180495_p(centerOfChunk.func_177981_b(landHeight));
            if (!topBlock.func_204520_s().func_206888_e()) {
                return false;
            }
        }
        List avoidStructures = (List)this.getGenerationConfig().avoidStructures.get();
        for (String structureName : avoidStructures) {
            Structure structure = (Structure)ForgeRegistries.STRUCTURE_FEATURES.getValue(new ResourceLocation(structureName));
            if (structure == null || !this.structureNearby(structure, chunkGenerator, seed, chunkRandom, chunkX, chunkZ)) continue;
            return false;
        }
        return super.func_230363_a_(chunkGenerator, biomeSource, seed, chunkRandom, chunkX, chunkZ, biome, chunkPos, (IFeatureConfig)featureConfig);
    }

    private boolean structureNearby(Structure structure, ChunkGenerator chunkGenerator, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkY) {
        StructureSeparationSettings structureseparationsettings = chunkGenerator.func_235957_b_().func_236197_a_(structure);
        if (structureseparationsettings != null) {
            for (int i = chunkX - 10; i <= chunkX + 10; ++i) {
                for (int j = chunkY - 10; j <= chunkY + 10; ++j) {
                    ChunkPos chunkpos = structure.func_236392_a_(structureseparationsettings, seed, chunkRandom, i, j);
                    if (i != chunkpos.field_77276_a || j != chunkpos.field_77275_b) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

