/*
 * Decompiled with CFR 0.152.
 */
package net.yezon.theabyss.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.network.IPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.yezon.theabyss.TheabyssModElements;
import net.yezon.theabyss.itemgroup.TheAbyssEntityItemGroup;

@TheabyssModElements.ModElement.Tag
public class AbyssTagEntity
extends TheabyssModElements.ModElement {
    public static EntityType entity = null;

    public AbyssTagEntity(TheabyssModElements instance) {
        super(instance, 188);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new ModelRegisterHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void initElements() {
        entity = (EntityType)EntityType.Builder.func_220322_a(CustomEntity::new, (EntityClassification)EntityClassification.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(20).setUpdateInterval(3).setCustomClientFactory(CustomEntity::new).func_220320_c().func_220321_a(0.9f, 1.4f).func_206830_a("abyss_tag").setRegistryName("abyss_tag");
        this.elements.entities.add(() -> entity);
        this.elements.items.add(() -> (Item)new SpawnEggItem(entity, -16777216, -10158107, new Item.Properties().func_200916_a(TheAbyssEntityItemGroup.tab)).setRegistryName("abyss_tag_spawn_egg"));
    }

    @SubscribeEvent
    public void addFeatureToBiomes(BiomeLoadingEvent event) {
        boolean biomeCriteria = false;
        if (new ResourceLocation("theabyss:the_abyss_plains_biome").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (!biomeCriteria) {
            return;
        }
        event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners(entity, 35, 1, 2));
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(this::setupAttributes);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)entity, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223324_d);
    }

    private void setupAttributes() {
        AttributeModifierMap.MutableAttribute ammma = MobEntity.func_233666_p_();
        ammma = ammma.func_233815_a_(Attributes.field_233821_d_, 0.3);
        ammma = ammma.func_233815_a_(Attributes.field_233818_a_, 10.0);
        ammma = ammma.func_233815_a_(Attributes.field_233826_i_, 0.0);
        ammma = ammma.func_233815_a_(Attributes.field_233823_f_, 6.0);
        GlobalEntityTypeAttributes.put((EntityType)entity, (AttributeModifierMap)ammma.func_233813_a_());
    }

    public static class Modelabyss_tag
    extends EntityModel<Entity> {
        private final ModelRenderer body;
        private final ModelRenderer rotation;
        private final ModelRenderer head;
        private final ModelRenderer head_r1;
        private final ModelRenderer head_r2;
        private final ModelRenderer BACK_LEFT;
        private final ModelRenderer BACK_RIGHT;
        private final ModelRenderer FRONT_LEFT;
        private final ModelRenderer FRONT_RIGHT;

        public Modelabyss_tag() {
            this.field_78090_t = 64;
            this.field_78089_u = 64;
            this.body = new ModelRenderer((Model)this);
            this.body.func_78793_a(0.0f, 5.0f, 2.0f);
            this.rotation = new ModelRenderer((Model)this);
            this.rotation.func_78793_a(0.0f, 0.0f, 0.0f);
            this.body.func_78792_a(this.rotation);
            this.setRotationAngle(this.rotation, 1.5708f, 0.0f, 0.0f);
            this.rotation.func_78784_a(0, 0).func_228303_a_(-6.0f, -11.0f, -7.0f, 12.0f, 20.0f, 9.0f, 0.0f, false);
            this.rotation.func_78784_a(44, 32).func_228303_a_(-2.0f, 2.0f, -8.0f, 4.0f, 6.0f, 1.0f, 0.0f, false);
            this.head = new ModelRenderer((Model)this);
            this.head.func_78793_a(0.0f, 4.0f, -8.0f);
            this.head.func_78784_a(0, 29).func_228303_a_(-4.0f, -4.0f, -6.0f, 8.0f, 8.0f, 6.0f, 0.0f, false);
            this.head.func_78784_a(0, 29).func_228303_a_(-1.5f, 0.0f, -7.5f, 3.0f, 3.0f, 2.0f, 0.0f, false);
            this.head_r1 = new ModelRenderer((Model)this);
            this.head_r1.func_78793_a(5.0f, 17.5f, 8.5f);
            this.head.func_78792_a(this.head_r1);
            this.setRotationAngle(this.head_r1, 0.0f, -0.3491f, -0.2182f);
            this.head_r1.func_78784_a(0, 43).func_228303_a_(-10.0f, -29.0f, -12.0f, 6.0f, 7.0f, 0.0f, 0.0f, false);
            this.head_r2 = new ModelRenderer((Model)this);
            this.head_r2.func_78793_a(8.5f, 20.25f, 3.5f);
            this.head.func_78792_a(this.head_r2);
            this.setRotationAngle(this.head_r2, 0.0f, 0.3491f, 0.2182f);
            this.head_r2.func_78784_a(12, 43).func_228303_a_(-10.0f, -29.0f, -12.0f, 6.0f, 7.0f, 0.0f, 0.0f, false);
            this.BACK_LEFT = new ModelRenderer((Model)this);
            this.BACK_LEFT.func_78793_a(4.0f, 12.0f, 7.0f);
            this.BACK_LEFT.func_78784_a(42, 16).func_228303_a_(-2.0f, 0.0f, -1.5f, 4.0f, 12.0f, 4.0f, 0.0f, false);
            this.BACK_RIGHT = new ModelRenderer((Model)this);
            this.BACK_RIGHT.func_78793_a(-4.0f, 12.0f, 7.0f);
            this.BACK_RIGHT.func_78784_a(42, 0).func_228303_a_(-2.0f, 0.0f, -1.5f, 4.0f, 12.0f, 4.0f, 0.0f, false);
            this.FRONT_LEFT = new ModelRenderer((Model)this);
            this.FRONT_LEFT.func_78793_a(4.0f, 12.0f, -6.0f);
            this.FRONT_LEFT.func_78784_a(40, 41).func_228303_a_(-2.0f, 0.0f, -1.0f, 4.0f, 12.0f, 4.0f, 0.0f, false);
            this.FRONT_RIGHT = new ModelRenderer((Model)this);
            this.FRONT_RIGHT.func_78793_a(-4.0f, 12.0f, -6.0f);
            this.FRONT_RIGHT.func_78784_a(28, 29).func_228303_a_(-2.0f, 0.0f, -1.0f, 4.0f, 12.0f, 4.0f, 0.0f, false);
        }

        public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            this.body.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
            this.head.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
            this.BACK_LEFT.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
            this.BACK_RIGHT.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
            this.FRONT_LEFT.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
            this.FRONT_RIGHT.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        }

        public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
        }

        public void func_225597_a_(Entity e, float f, float f1, float f2, float f3, float f4) {
            this.head.field_78796_g = f3 / 57.295776f;
            this.head.field_78795_f = f4 / 57.295776f;
            this.FRONT_RIGHT.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * -1.0f * f1;
            this.BACK_LEFT.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * -1.0f * f1;
            this.FRONT_LEFT.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * 1.0f * f1;
            this.BACK_RIGHT.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * 1.0f * f1;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class GlowingLayer<T extends Entity, M extends EntityModel<T>>
    extends LayerRenderer<T, M> {
        public GlowingLayer(IEntityRenderer<T, M> er) {
            super(er);
        }

        public void func_225628_a_(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228652_i_((ResourceLocation)new ResourceLocation("theabyss:textures/abyss_tag_22.png")));
            this.func_215332_c().func_225598_a_(matrixStackIn, ivertexbuilder, 0xF00000, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public static class CustomEntity
    extends MonsterEntity {
        public CustomEntity(FMLPlayMessages.SpawnEntity packet, World world) {
            this((EntityType<CustomEntity>)entity, world);
        }

        public CustomEntity(EntityType<CustomEntity> type, World world) {
            super(type, world);
            this.field_70728_aV = 3;
            this.func_94061_f(false);
        }

        public IPacket<?> func_213297_N() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.2, false));
            this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
            this.field_70714_bg.func_75776_a(3, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.8));
            this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
        }

        public CreatureAttribute func_70668_bt() {
            return CreatureAttribute.field_223222_a_;
        }

        protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
            super.func_213333_a(source, looting, recentlyHitIn);
            this.func_199701_a_(new ItemStack((IItemProvider)Items.field_151083_be, 1));
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
        }

        public SoundEvent func_184615_bR() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
        }
    }

    private static class ModelRegisterHandler {
        private ModelRegisterHandler() {
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public void registerModels(ModelRegistryEvent event) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)entity, renderManager -> new MobRenderer(renderManager, new Modelabyss_tag(), 0.5f){
                {
                    super(x0, x1, x2);
                    this.func_177094_a(new GlowingLayer(this));
                }

                public ResourceLocation func_110775_a(Entity entity) {
                    return new ResourceLocation("theabyss:textures/abyss_tag_22.png");
                }
            });
        }
    }
}

