/*
 * Decompiled with CFR 0.152.
 */
package net.yezon.theabyss.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.BipedRenderer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.network.IPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.yezon.theabyss.TheabyssModElements;
import net.yezon.theabyss.entity.TheRokaEndAllyEntity;
import net.yezon.theabyss.item.NosajSwordItem;
import net.yezon.theabyss.itemgroup.TheAbyssEntityItemGroup;
import net.yezon.theabyss.procedures.NosajBossEntityDiesProcedure;

@TheabyssModElements.ModElement.Tag
public class NosajBossEntity
extends TheabyssModElements.ModElement {
    public static EntityType entity = null;

    public NosajBossEntity(TheabyssModElements instance) {
        super(instance, 971);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new ModelRegisterHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void initElements() {
        entity = (EntityType)EntityType.Builder.func_220322_a(CustomEntity::new, (EntityClassification)EntityClassification.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(50).setUpdateInterval(3).setCustomClientFactory(CustomEntity::new).func_220320_c().func_220321_a(0.6f, 1.8f).func_206830_a("nosaj_boss").setRegistryName("nosaj_boss");
        this.elements.entities.add(() -> entity);
        this.elements.items.add(() -> (Item)new SpawnEggItem(entity, -10027060, -1, new Item.Properties().func_200916_a(TheAbyssEntityItemGroup.tab)).setRegistryName("nosaj_boss_spawn_egg"));
    }

    @SubscribeEvent
    public void addFeatureToBiomes(BiomeLoadingEvent event) {
        boolean biomeCriteria = false;
        if (new ResourceLocation("theabyss:bossuselessbiome").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (!biomeCriteria) {
            return;
        }
        event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners(entity, 1, 1, 1));
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(this::setupAttributes);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)entity, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223324_d);
    }

    private void setupAttributes() {
        AttributeModifierMap.MutableAttribute ammma = MobEntity.func_233666_p_();
        ammma = ammma.func_233815_a_(Attributes.field_233821_d_, 0.3);
        ammma = ammma.func_233815_a_(Attributes.field_233818_a_, 1000.0);
        ammma = ammma.func_233815_a_(Attributes.field_233826_i_, 10.0);
        ammma = ammma.func_233815_a_(Attributes.field_233823_f_, 20.0);
        ammma = ammma.func_233815_a_(Attributes.field_233820_c_, 3.0);
        ammma = ammma.func_233815_a_(Attributes.field_233824_g_, 1.5);
        GlobalEntityTypeAttributes.put((EntityType)entity, (AttributeModifierMap)ammma.func_233813_a_());
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class GlowingLayer<T extends Entity, M extends EntityModel<T>>
    extends LayerRenderer<T, M> {
        public GlowingLayer(IEntityRenderer<T, M> er) {
            super(er);
        }

        public void func_225628_a_(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228652_i_((ResourceLocation)new ResourceLocation("theabyss:textures/nosaj.png")));
            this.func_215332_c().func_225598_a_(matrixStackIn, ivertexbuilder, 0xF00000, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public static class CustomEntity
    extends MonsterEntity {
        private final ServerBossInfo bossInfo = new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.WHITE, BossInfo.Overlay.PROGRESS);

        public CustomEntity(FMLPlayMessages.SpawnEntity packet, World world) {
            this((EntityType<CustomEntity>)entity, world);
        }

        public CustomEntity(EntityType<CustomEntity> type, World world) {
            super(type, world);
            this.field_70728_aV = 50;
            this.func_94061_f(false);
            this.func_200203_b((ITextComponent)new StringTextComponent("Nosaj End Boss"));
            this.func_174805_g(true);
            this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)NosajSwordItem.block, 1));
        }

        public IPacket<?> func_213297_N() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.2, false));
            this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
            this.field_70714_bg.func_75776_a(3, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.8));
            this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
            this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, false, false));
            this.field_70715_bh.func_75776_a(6, (Goal)new NearestAttackableTargetGoal((MobEntity)this, TheRokaEndAllyEntity.CustomEntity.class, false, false));
        }

        public CreatureAttribute func_70668_bt() {
            return CreatureAttribute.field_223222_a_;
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(""));
        }

        public SoundEvent func_184615_bR() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(""));
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            if (source.func_76364_f() instanceof ArrowEntity) {
                return false;
            }
            if (source.func_76364_f() instanceof PotionEntity) {
                return false;
            }
            if (source == DamageSource.field_76379_h) {
                return false;
            }
            if (source == DamageSource.field_76367_g) {
                return false;
            }
            if (source == DamageSource.field_76369_e) {
                return false;
            }
            if (source == DamageSource.field_180137_b) {
                return false;
            }
            return super.func_70097_a(source, amount);
        }

        public void func_70645_a(DamageSource source) {
            super.func_70645_a(source);
            double x = this.func_226277_ct_();
            double y = this.func_226278_cu_();
            double z = this.func_226281_cx_();
            Entity sourceentity = source.func_76346_g();
            CustomEntity entity = this;
            HashMap<String, Object> $_dependencies = new HashMap<String, Object>();
            $_dependencies.put("entity", (Object)entity);
            $_dependencies.put("sourceentity", sourceentity);
            $_dependencies.put("x", x);
            $_dependencies.put("y", y);
            $_dependencies.put("z", z);
            $_dependencies.put("world", this.field_70170_p);
            NosajBossEntityDiesProcedure.executeProcedure($_dependencies);
        }

        public boolean func_184222_aU() {
            return false;
        }

        public void func_184178_b(ServerPlayerEntity player) {
            super.func_184178_b(player);
            this.bossInfo.func_186760_a(player);
        }

        public void func_184203_c(ServerPlayerEntity player) {
            super.func_184203_c(player);
            this.bossInfo.func_186761_b(player);
        }

        public void func_70619_bc() {
            super.func_70619_bc();
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        }
    }

    private static class ModelRegisterHandler {
        private ModelRegisterHandler() {
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public void registerModels(ModelRegistryEvent event) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)entity, renderManager -> {
                BipedRenderer customRender = new BipedRenderer(renderManager, new BipedModel(0.0f), 0.5f){

                    public ResourceLocation func_110775_a(Entity entity) {
                        return new ResourceLocation("theabyss:textures/nosaj.png");
                    }
                };
                customRender.func_177094_a((LayerRenderer)new BipedArmorLayer((IEntityRenderer)customRender, new BipedModel(0.5f), new BipedModel(1.0f)));
                customRender.func_177094_a(new GlowingLayer(customRender));
                return customRender;
            });
        }
    }
}

