/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.blay09.mods.waystones.api.IAttunementItem;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.block.WaystoneBlockBase;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.blay09.mods.waystones.item.ModItems;
import net.blay09.mods.waystones.tileentity.WarpPlateTileEntity;
import net.blay09.mods.waystones.tileentity.WaystoneTileEntityBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.StringUtils;

public class WarpPlateBlock
extends WaystoneBlockBase {
    private static final Style GALACTIC_STYLE = Style.field_240709_b_.func_240719_a_(new ResourceLocation("minecraft", "alt"));
    private static final VoxelShape SHAPE = VoxelShapes.func_197872_a((VoxelShape)WarpPlateBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), (VoxelShape)WarpPlateBlock.func_208617_a((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0)).func_197753_c();
    public static final BooleanProperty ACTIVE = BooleanProperty.func_177716_a((String)"active");

    public WarpPlateBlock() {
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof WarpPlateTileEntity && !player.field_71075_bZ.field_75098_d) {
            boolean isSilkTouch = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185306_r, (LivingEntity)player) > 0;
            WarpPlateTileEntity warpPlate = (WarpPlateTileEntity)tileEntity;
            if (warpPlate.isCompletedFirstAttunement()) {
                ItemStackHandler itemStackHandler = warpPlate.getItemStackHandler();
                for (int i = 0; i < itemStackHandler.getSlots(); ++i) {
                    IWaystone waystoneAttunedTo;
                    ItemStack itemStack = itemStackHandler.getStackInSlot(i);
                    if (!isSilkTouch && itemStack.func_77973_b() == ModItems.attunedShard && (waystoneAttunedTo = ((IAttunementItem)ModItems.attunedShard).getWaystoneAttunedTo(itemStack)) != null && waystoneAttunedTo.getWaystoneUid().equals(warpPlate.getWaystone().getWaystoneUid())) continue;
                    WarpPlateBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)itemStack);
                }
            }
        }
        super.func_176208_a(world, pos, state, player);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{ACTIVE});
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        TileEntity tileEntity;
        if (entity.func_226277_ct_() >= (double)pos.func_177958_n() && entity.func_226277_ct_() < (double)(pos.func_177958_n() + 1) && entity.func_226278_cu_() >= (double)pos.func_177956_o() && entity.func_226278_cu_() < (double)(pos.func_177956_o() + 1) && entity.func_226281_cx_() >= (double)pos.func_177952_p() && entity.func_226281_cx_() < (double)(pos.func_177952_p() + 1) && !world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof WarpPlateTileEntity) {
            ((WarpPlateTileEntity)tileEntity).onEntityCollision(entity);
        }
    }

    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        block4: {
            TileEntity tileEntity;
            if (!((Boolean)state.func_177229_b((Property)ACTIVE)).booleanValue() || !((tileEntity = world.func_175625_s(pos)) instanceof WarpPlateTileEntity)) break block4;
            IWaystone targetWaystone = ((WarpPlateTileEntity)tileEntity).getTargetWaystone();
            if (targetWaystone != null && targetWaystone.isValid()) {
                for (int i = 0; i < 50; ++i) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_239814_an_, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + Math.random() * 2.0, (double)pos.func_177952_p() + Math.random(), 0.0, 0.0, 0.0);
                    world.func_195594_a((IParticleData)ParticleTypes.field_197599_J, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + Math.random() * 2.0, (double)pos.func_177952_p() + Math.random(), 0.0, 0.0, 0.0);
                }
            } else {
                for (int i = 0; i < 10; ++i) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o(), (double)pos.func_177952_p() + Math.random(), 0.0, (double)0.01f, 0.0);
                }
            }
        }
    }

    @Override
    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new WarpPlateTileEntity();
    }

    @Override
    protected void handleActivation(World world, BlockPos pos, PlayerEntity player, WaystoneTileEntityBase tileEntity, IWaystone waystone) {
        if (!world.field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)tileEntity.getWaystoneSelectionContainerProvider(), (BlockPos)pos);
        }
    }

    @Override
    protected void addWaystoneNameToTooltip(List<ITextComponent> tooltip, WaystoneProxy waystone) {
        String name = StringUtils.substringBeforeLast((String)waystone.getName(), (String)" ");
        StringTextComponent galacticName = new StringTextComponent(name);
        galacticName.func_240699_a_(WarpPlateBlock.getColorForName(name));
        galacticName.func_240703_c_(GALACTIC_STYLE);
        tooltip.add((ITextComponent)galacticName);
    }

    public static TextFormatting getColorForName(String name) {
        int colorIndex = Math.abs(name.hashCode()) % 15;
        TextFormatting textFormatting = TextFormatting.func_175744_a((int)colorIndex);
        if (textFormatting == TextFormatting.GRAY) {
            return TextFormatting.LIGHT_PURPLE;
        }
        if (textFormatting == TextFormatting.DARK_GRAY) {
            return TextFormatting.DARK_PURPLE;
        }
        if (textFormatting == TextFormatting.BLACK) {
            return TextFormatting.GOLD;
        }
        return textFormatting != null ? textFormatting : TextFormatting.GRAY;
    }

    public static ITextComponent getGalacticName(IWaystone waystone) {
        String name = StringUtils.substringBeforeLast((String)waystone.getName(), (String)" ");
        StringTextComponent galacticName = new StringTextComponent(name);
        galacticName.func_240699_a_(WarpPlateBlock.getColorForName(name));
        galacticName.func_240703_c_(GALACTIC_STYLE);
        return galacticName;
    }
}

