/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.compat;

import java.util.function.Function;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneTypes;
import net.blay09.mods.waystones.tileentity.WarpPlateTileEntity;
import net.blay09.mods.waystones.tileentity.WaystoneTileEntityBase;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.InterModComms;

public class TheOneProbeAddon {
    public static void register() {
        InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", TopInitializer::new);
    }

    public static class ProbeInfoProvider
    implements IProbeInfoProvider {
        public String getID() {
            return "waystones";
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo info, PlayerEntity playerEntity, World world, BlockState state, IProbeHitData data) {
            TileEntity tileEntity = world.func_175625_s(data.getPos());
            if (!(tileEntity instanceof WarpPlateTileEntity) && tileEntity instanceof WaystoneTileEntityBase) {
                boolean isActivated;
                IWaystone waystone = ((WaystoneTileEntityBase)tileEntity).getWaystone();
                boolean bl = isActivated = !waystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE) || PlayerWaystoneManager.isWaystoneActivated(playerEntity, waystone);
                if (isActivated && waystone.hasName() && waystone.isValid()) {
                    info.text((ITextComponent)new StringTextComponent(waystone.getName()));
                } else {
                    info.text((ITextComponent)new TranslationTextComponent("tooltip.waystones.undiscovered"));
                }
            }
        }
    }

    public static class TopInitializer
    implements Function<ITheOneProbe, Void> {
        @Override
        @Nullable
        public Void apply(@Nullable ITheOneProbe top) {
            if (top != null) {
                top.registerProvider((IProbeInfoProvider)new ProbeInfoProvider());
            }
            return null;
        }
    }
}

