/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.network.message;

import java.util.function.Supplier;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.Waystone;
import net.blay09.mods.waystones.core.WaystoneEditPermissions;
import net.blay09.mods.waystones.core.WaystoneManager;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class EditWaystoneMessage {
    private final IWaystone waystone;
    private final String name;
    private final boolean isGlobal;

    public EditWaystoneMessage(IWaystone waystone, String name, boolean isGlobal) {
        this.waystone = waystone;
        this.name = name;
        this.isGlobal = isGlobal;
    }

    public static void encode(EditWaystoneMessage message, PacketBuffer buf) {
        buf.func_179252_a(message.waystone.getWaystoneUid());
        buf.func_180714_a(message.name);
        buf.writeBoolean(message.isGlobal);
    }

    public static EditWaystoneMessage decode(PacketBuffer buf) {
        WaystoneProxy waystone = new WaystoneProxy(buf.func_179253_g());
        String name = buf.func_150789_c(255);
        boolean isGlobal = buf.readBoolean();
        return new EditWaystoneMessage(waystone, name, isGlobal);
    }

    public static void handle(EditWaystoneMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayerEntity player = context.getSender();
            if (player == null) {
                return;
            }
            WaystoneEditPermissions permissions = PlayerWaystoneManager.mayEditWaystone((PlayerEntity)player, player.field_70170_p, message.waystone);
            if (permissions != WaystoneEditPermissions.ALLOW) {
                return;
            }
            BlockPos pos = message.waystone.getPos();
            if (player.func_70092_e((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f)) > 64.0) {
                return;
            }
            Waystone backingWaystone = (Waystone)((WaystoneProxy)message.waystone).getBackingWaystone();
            String legalName = EditWaystoneMessage.makeNameLegal(message.name);
            backingWaystone.setName(legalName);
            if (PlayerWaystoneManager.mayEditGlobalWaystones((PlayerEntity)player)) {
                if (!backingWaystone.isGlobal() && message.isGlobal) {
                    PlayerWaystoneManager.activeWaystoneForEveryone(backingWaystone);
                }
                backingWaystone.setGlobal(message.isGlobal);
            }
            WaystoneManager.get().func_76185_a();
            WaystoneSyncManager.sendWaystoneUpdateToAll(backingWaystone);
            player.func_71053_j();
        });
        context.setPacketHandled(true);
    }

    private static String makeNameLegal(String name) {
        String inventoryButtonMode = (String)WaystonesConfig.SERVER.inventoryButton.get();
        if (inventoryButtonMode.equals(name) && WaystoneManager.get().findWaystoneByName(name).isPresent()) {
            return name + "*";
        }
        return name;
    }
}

