/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.networking;

import com.google.common.collect.Maps;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.architectury.networking.NetworkManager;
import me.shedaniel.architectury.platform.Platform;
import me.shedaniel.architectury.utils.Env;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

public final class NetworkChannel {
    private final ResourceLocation id;
    private final Map<Class<?>, MessageInfo<?>> encoders = Maps.newHashMap();

    private NetworkChannel(ResourceLocation id) {
        this.id = id;
    }

    public static NetworkChannel create(ResourceLocation id) {
        return new NetworkChannel(id);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0")
    public <T> void register(NetworkManager.Side side, Class<T> type, BiConsumer<T, PacketBuffer> encoder, Function<PacketBuffer, T> decoder, BiConsumer<T, Supplier<NetworkManager.PacketContext>> messageConsumer) {
        this.register(type, encoder, decoder, messageConsumer);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0")
    public <T> void register(Optional<NetworkManager.Side> side, Class<T> type, BiConsumer<T, PacketBuffer> encoder, Function<PacketBuffer, T> decoder, BiConsumer<T, Supplier<NetworkManager.PacketContext>> messageConsumer) {
        this.register(type, encoder, decoder, messageConsumer);
    }

    public <T> void register(Class<T> type, BiConsumer<T, PacketBuffer> encoder, Function<PacketBuffer, T> decoder, BiConsumer<T, Supplier<NetworkManager.PacketContext>> messageConsumer) {
        String s = UUID.nameUUIDFromBytes(type.getName().getBytes(StandardCharsets.UTF_8)).toString().replace("-", "");
        MessageInfo info = new MessageInfo(new ResourceLocation(this.id + "/" + s), encoder, decoder, messageConsumer);
        this.encoders.put(type, info);
        NetworkManager.NetworkReceiver receiver = (buf, context) -> info.messageConsumer.accept(info.decoder.apply(buf), () -> context);
        NetworkManager.registerReceiver(NetworkManager.c2s(), info.packetId, receiver);
        if (Platform.getEnvironment() == Env.CLIENT) {
            NetworkManager.registerReceiver(NetworkManager.s2c(), info.packetId, receiver);
        }
    }

    public static long hashCodeString(String str) {
        long h = 0L;
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            h = 31L * h + (long)str.charAt(i);
        }
        return h;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0")
    public <T> void register(int id, Class<T> type, BiConsumer<T, PacketBuffer> encoder, Function<PacketBuffer, T> decoder, BiConsumer<T, Supplier<NetworkManager.PacketContext>> messageConsumer) {
        this.register(type, encoder, decoder, messageConsumer);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0")
    public <T> void register(NetworkManager.Side side, int id, Class<T> type, BiConsumer<T, PacketBuffer> encoder, Function<PacketBuffer, T> decoder, BiConsumer<T, Supplier<NetworkManager.PacketContext>> messageConsumer) {
        this.register(type, encoder, decoder, messageConsumer);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0")
    public <T> void register(Optional<NetworkManager.Side> side, int id, Class<T> type, BiConsumer<T, PacketBuffer> encoder, Function<PacketBuffer, T> decoder, BiConsumer<T, Supplier<NetworkManager.PacketContext>> messageConsumer) {
        this.register(type, encoder, decoder, messageConsumer);
    }

    public <T> IPacket<?> toPacket(NetworkManager.Side side, T message) {
        MessageInfo<?> messageInfo = Objects.requireNonNull(this.encoders.get(message.getClass()), "Unknown message type! " + message);
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        ((MessageInfo)messageInfo).encoder.accept(message, buf);
        return NetworkManager.toPacket(side, ((MessageInfo)messageInfo).packetId, buf);
    }

    public <T> void sendToPlayer(ServerPlayerEntity player, T message) {
        Objects.requireNonNull(player, (String)"Unable to send packet to a 'null' player!").field_71135_a.func_147359_a(this.toPacket(NetworkManager.s2c(), message));
    }

    public <T> void sendToPlayers(Iterable<ServerPlayerEntity> players, T message) {
        IPacket<?> packet = this.toPacket(NetworkManager.s2c(), message);
        for (ServerPlayerEntity player : players) {
            Objects.requireNonNull(player, (String)"Unable to send packet to a 'null' player!").field_71135_a.func_147359_a(packet);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public <T> void sendToServer(T message) {
        if (Minecraft.func_71410_x().func_147114_u() == null) {
            throw new IllegalStateException("Unable to send packet to the server while not in game!");
        }
        Minecraft.func_71410_x().func_147114_u().func_147297_a(this.toPacket(NetworkManager.c2s(), message));
    }

    @OnlyIn(value=Dist.CLIENT)
    public <T> boolean canServerReceive(Class<T> type) {
        return NetworkManager.canServerReceive(((MessageInfo)this.encoders.get(type)).packetId);
    }

    public <T> boolean canPlayerReceive(ServerPlayerEntity player, Class<T> type) {
        return NetworkManager.canPlayerReceive(player, ((MessageInfo)this.encoders.get(type)).packetId);
    }

    private static final class MessageInfo<T> {
        private final ResourceLocation packetId;
        private final BiConsumer<T, PacketBuffer> encoder;
        private final Function<PacketBuffer, T> decoder;
        private final BiConsumer<T, Supplier<NetworkManager.PacketContext>> messageConsumer;

        public MessageInfo(ResourceLocation packetId, BiConsumer<T, PacketBuffer> encoder, Function<PacketBuffer, T> decoder, BiConsumer<T, Supplier<NetworkManager.PacketContext>> messageConsumer) {
            this.packetId = packetId;
            this.encoder = encoder;
            this.decoder = decoder;
            this.messageConsumer = messageConsumer;
        }
    }
}

