/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.networking.simple;

import me.shedaniel.architectury.networking.NetworkManager;
import me.shedaniel.architectury.networking.simple.BaseC2SMessage;
import me.shedaniel.architectury.networking.simple.BaseS2CMessage;
import me.shedaniel.architectury.networking.simple.MessageDecoder;
import me.shedaniel.architectury.networking.simple.MessageType;
import me.shedaniel.architectury.platform.Platform;
import me.shedaniel.architectury.utils.Env;
import net.minecraft.util.ResourceLocation;

public class SimpleNetworkManager {
    public final String namespace;

    public static SimpleNetworkManager create(String namespace) {
        return new SimpleNetworkManager(namespace);
    }

    private SimpleNetworkManager(String namespace) {
        this.namespace = namespace;
    }

    public MessageType registerS2C(String id, MessageDecoder<BaseS2CMessage> decoder) {
        MessageType messageType = new MessageType(this, new ResourceLocation(this.namespace, id), NetworkManager.s2c());
        if (Platform.getEnvironment() == Env.CLIENT) {
            NetworkManager.NetworkReceiver receiver = decoder.createReceiver();
            NetworkManager.registerReceiver(NetworkManager.s2c(), messageType.getId(), receiver);
        }
        return messageType;
    }

    public MessageType registerC2S(String id, MessageDecoder<BaseC2SMessage> decoder) {
        MessageType messageType = new MessageType(this, new ResourceLocation(this.namespace, id), NetworkManager.c2s());
        NetworkManager.NetworkReceiver receiver = decoder.createReceiver();
        NetworkManager.registerReceiver(NetworkManager.c2s(), messageType.getId(), receiver);
        return messageType;
    }
}

